DELIMITER $$
DROP PROCEDURE IF EXISTS V20230726153409__Create_LanguageDocument $$
CREATE PROCEDURE V20230726153409__Create_LanguageDocument()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='language_document')) THEN 
CREATE TABLE language_document(  
  id BIGINT(20) NOT NULL AUTO_INCREMENT,
  studentLanguageId BIGINT(20) NOT NULL,
  documentId BIGINT(20) NOT NULL,
  lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  lastUpdatedBy BIGINT(20) NOT NULL,
  PRIMARY KEY (id),
  CONSTRAINT `language_document_FK` FOREIGN KEY (`studentLanguageId`) REFERENCES student_language(`id`),
  CONSTRAINT `language_document_documentId_FK` FOREIGN KEY (`documentId`) REFERENCES documents(`id`),
  CONSTRAINT `language_document_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES users(`id`));
END IF; 

END $$
CALL V20230726153409__Create_LanguageDocument () $$ 
DROP PROCEDURE IF EXISTS V20230726153409__Create_LanguageDocument $$ 
DELIMITER ;