DELIMITER $$
DROP PROCEDURE IF EXISTS V20230726193354__Alter_hostel_student_category $$
CREATE PROCEDURE V20230726193354__Alter_hostel_student_category()
BEGIN

IF EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='hostel_student_category')) THEN 
IF NOT EXISTS ((select column_name from INFORMATION_SCHEMA.columns where table_schema=DATABASE() and table_name = 'hostel_student_category' and column_name = 'feeAmount')) THEN
ALTER Table `hostel_student_category`
Add column `feeAmount` double(17,2) unsigned DEFAULT Null after `itemValue`;
END IF; 
END IF;

IF  EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='standard_master_items')) THEN 
SET @standardMasterId=(select id from standard_master where tableName = 'hostel_student_category');

IF NOT EXISTS((SELECT * FROM standard_master_items WHERE standardMasterId=@standardMasterId AND dbFieldName='feeAmount')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('feeAmount','FEE_AMOUNT',@standardMasterId,'Double',NULL,3,0,NULL,NULL,NULL,0,0,1,NULL,NULL,NULL,1,now());
END IF; 
END IF;

-- translations

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'FEEANDPAYMENTS' and keyName = 'FEE_AMOUNT')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('FEEANDPAYMENTS', 'FEE_AMOUNT', 'Fee Amount', 'Fee Amount',now(),1);
END IF;

END $$
CALL V20230726193354__Alter_hostel_student_category() $$
DROP PROCEDURE IF EXISTS V20230726193354__Alter_hostel_student_category $$
DELIMITER ;