DELIMITER $$
DROP PROCEDURE IF EXISTS V20230801150209__Create_ApplicationRequestInProcessEvent $$
CREATE PROCEDURE V20230801150209__Create_ApplicationRequestInProcessEvent()
BEGIN
 
 IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='APPLICATION_REQUEST_IN_PROCESS')) THEN
 SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='ADMISSION');
 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
 INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'APPLICATION_REQUEST_IN_PROCESS');
 
 SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
 SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='APPLICATION_REQUEST_IN_PROCESS');
 INSERT INTO `system_msg_event`
 (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
 VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'APPLICATION_REQUEST_IN_PROCESS', 'Application Request In Process', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Application Request In Process');
 
 
 SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
 INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
 VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 -- Template data provider for the Event
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICATION_REQUEST_IN_PROCESS_DL', 'SQL');
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICATION_REQUEST_IN_PROCESS_RECIPIENT', 'SQL');
 
 -- Create Recipient Type
 
 SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_REQUEST_IN_PROCESS_RECIPIENT');
 INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'APPLICATION_REQUEST_IN_PROCESS_RECIPIENT');
 
 
 SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_REQUEST_IN_PROCESS_DL');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPLICATION_REQUEST_IN_PROCESS_RECIPIENT');
 INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
 VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);
 
 
 -- Setting the query for the Applicant distribution list
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_REQUEST_IN_PROCESS_DL');
 INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT T1.id as USER_ID FROM application T1 WHERE T1.id IN (namedParams)",NULL);
 
 
 -- Setting the query for the User Recipient
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_REQUEST_IN_PROCESS_RECIPIENT');
 INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
 "SELECT
    T1.`id` AS ID,    
    T2.`firstName` AS FIRST_NAME,
    T2.`lastName`  AS LAST_NAME,
    T1.`code` AS APPLICATION_ID,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T4.`programName` AS PROGRAM_NAME,
    T6.`countryName` AS COUNTRY_CODE,
    T7.`countryRegionName` AS COUNTRY_REGION,
    T8.`displayName` As ACADEMY_LOCATION_DISPLAY_NAME,
    T11.`itemValue` As INTAKE_YEAR,
    T13.`primaryeEmailId` AS ACADEMY_LOCATION_EMAIL_ID,
    T13.`phoneNo` AS ACADEMY_LOCATION_PHONE_NUMBER,
    T13.`websiteURL` AS ACADEMY_LOCATION_WEBSITE_URL,
    'APPLICANT' AS USER_TYPE_KEY
  FROM
    application T1
    LEFT JOIN
    applicant_person T2 ON T2.id = T1.applicantPersonId
    LEFT JOIN
    application_program T3 ON T3.applicationId = T1.id
    LEFT JOIN
    programs T4 ON T4.id = T3.programId
    LEFT JOIN
    applicant_address T5 ON T5.applicantPersonId = T2.id
    LEFT JOIN
    country T6 ON T6.id = T5.countryId
    LEFT JOIN
    country_region T7 ON T7.id = T5.countryRegionId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    prog_batch_seat_config T9 ON T9.id = T3.progBatchSeatConfigId
    LEFT JOIN
    batches T10 ON T10.id = T9.programBatchId
    LEFT JOIN
    intake_year T11 ON T11.id = T10.intakeYearId
    LEFT JOIN
    academy_location_addresses T12 ON T12.academyLocationId = T3.academyLocationId
    LEFT JOIN
    address T13 ON T13.id = T12.addressId and T13.addressTypeId=10
    
	WHERE
    T1.id IN (namedParams) limit 1",'{
     "id": 1,
     "searchResultViewColumns": [
        {
            "id": 1,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
		{
            "id": 2,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "code",
            "resultKey": "APPLICATION_ID",
            "displayCode": "",
            "displayOrder": 2
        },
		 {
            "id": 4,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 3
        },
		 {
            "id": 5,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "programName",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "countryName",
            "resultKey": "COUNTRY_CODE",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "countryRegionName",
            "resultKey": "COUNTRY_REGION",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "displayName",
            "resultKey": "ACADEMY_LOCATION_DISPLAY_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 9
        },		
		{
            "id": 11,
            "value": "itemValue",
            "resultKey": "INTAKE_YEAR",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "phoneNo",
            "resultKey": "ACADEMY_LOCATION_PHONE_NUMBER",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "websiteURL",
            "resultKey": "ACADEMY_LOCATION_WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 13
        }
    ]
 }');
 
 SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
 SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='APPLICATION_REQUEST_IN_PROCESS_DL');
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T3.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
 
 SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='APPLICATION_REQUEST_IN_PROCESS');
 
 SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
 SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='APPLICATION_REQUEST_IN_PROCESS');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPLICATION_REQUEST_IN_PROCESS_RECIPIENT');
 SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');
 
 
 INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
 VALUES(@msgtemplateconfigId+1,'Application In Process',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Application In Process',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');
 
 
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Application In Process','<html>
 <head>
 	<title></title>
 </head>
 <body>
 <div style="display: none;">&nbsp;</div>
 
 <table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
 	<tbody>
 		<tr style="background-color:#f0f0f0; line-height:20px;">
 			<td style="padding:20px 20px 20px 20px;">
 			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Dear&nbsp;$recipientData[&quot;FIRST_NAME&quot;]$recipientData[&quot;LAST_NAME&quot;]</p>
 			
 			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">We notice that you are in the process of your completing your application to study the $recipientData[&quot;PROGRAM_NAME&quot;] at $recipientData[&quot;ACADEMY_LOCATION_DISPLAY_NAME&quot;] for $recipientData[&quot;INTAKE_YEAR&quot;].</p>
 
 			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Please note your Application ID for the above application is $recipientData[&quot;APPLICATION_ID&quot;] .The email address used in this application is $recipientData[&quot;EMAIL_ID&quot;] </p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Should you have any queries – please contact the campus.</p>
      
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">We look forward to engaging with you further.</p>
      
              
             <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Kind regards</p>

             <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">The IIEs $recipientData[&quot;ACADEMY_LOCATION_DISPLAY_NAME&quot;]</p>
             <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Email Address: $recipientData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;]</p>
             <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Phone Number: $recipientData[&quot;ACADEMY_LOCATION_PHONE_NUMBER&quot;]</p>
             <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Website: $recipientData[&quot;ACADEMY_LOCATION_WEBSITE_URL&quot;]</p>

 			</td>
 		</tr>	
 	</tbody>
 </table>
 </body>
 </html>');
 
  INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Application In Process','');
 
 
INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData[&quot;FIRST_NAME&quot;]$recipientData[&quot;LAST_NAME&quot;] We notice you are in the process of your completing your application-your Application ID is $recipientData[&quot;APPLICATION_ID&quot;]. The email address used in this application is $recipientData[&quot;EMAIL_ID&quot;]. The IIEs $recipientData[&quot;ACADEMY_LOCATION_DISPLAY_NAME&quot;]');

-- End Messaging for APPLICATION_REQUEST_IN_PROCESS Event
END IF;

END $$
CALL V20230801150209__Create_ApplicationRequestInProcessEvent () $$ 
DROP PROCEDURE IF EXISTS V20230801150209__Create_ApplicationRequestInProcessEvent $$ 
DELIMITER ;