DELIMITER $$
DROP PROCEDURE IF EXISTS V20230816174016__Create_LessonPlanningSubObjectiveCSMTable $$
CREATE PROCEDURE V20230816174016__Create_LessonPlanningSubObjectiveCSMTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='lesson_planning_sub_objective_csm')) THEN 
CREATE TABLE `lesson_planning_sub_objective_csm` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`itemCode` VARCHAR(100) NOT NULL,
	`itemValue` VARCHAR(500) NOT NULL,
	`visibility` BIT(1) DEFAULT 0,
	`sequence` BIGINT(20) DEFAULT 0,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	UNIQUE KEY itemCode_UNIQUE (itemCode),
    KEY fk_lesson_planning_sub_objective_csm_lastUpdatedBy_idx (lastUpdatedBy),
    CONSTRAINT fk_lesson_planning_sub_objective_csm_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users(id));
END IF; 

END $$
CALL V20230816174016__Create_LessonPlanningSubObjectiveCSMTable () $$ 
DROP PROCEDURE IF EXISTS V20230816174016__Create_LessonPlanningSubObjectiveCSMTable $$ 
DELIMITER ;