DELIMITER $$
DROP PROCEDURE IF EXISTS V20230821122356__Create_StudentJourneySettingTable $$
CREATE PROCEDURE V20230821122356__Create_StudentJourneySettingTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_journey_setting')) THEN

CREATE TABLE `student_journey_setting` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` BIGINT(20) NOT NULL,
  `programId` BIGINT(20) NOT NULL,
  `batchId` BIGINT(20) NOT NULL,
  `academicTermSeq` INT NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_student_journey_setting_academyLocationId_idx` (`academyLocationId` ASC),
  INDEX `fk_student_journey_setting_programId_idx` (`programId` ASC),
  INDEX `fk_student_journey_setting_batchId_idx` (`batchId` ASC),
  INDEX `student_journey_setting_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_student_journey_setting_alid`
    FOREIGN KEY (`academyLocationId`)
    REFERENCES `academy_location` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_student_journey_setting_programid`
    FOREIGN KEY (`programId`)
    REFERENCES `programs` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_student_journey_setting_batchid`
    FOREIGN KEY (`batchId`)
    REFERENCES `batches` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_student_journey_setting_lastUpdateBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF;   

END $$
CALL V20230821122356__Create_StudentJourneySettingTable () $$ 
DROP PROCEDURE IF EXISTS V20230821122356__Create_StudentJourneySettingTable $$ 
DELIMITER ;