DELIMITER $$
DROP PROCEDURE IF EXISTS V20230822122527__Create_InteliMali $$
CREATE PROCEDURE V20230822122527__Create_InteliMali()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='intelli_mali')) THEN 
CREATE TABLE `intelli_mali`(
`id` bigint NOT NULL AUTO_INCREMENT,
`sequenceNumber` bigint(20) NULL,
`accountingYearId` bigint(20) NOT NULL,
`instituteCSM` bigint(20) NOT NULL,
`studentId` bigint(20) NOT NULL,
`suNumber` varchar(20) NULL,
`programId` bigint(20) NOT NULL,
`academyLocationId` bigint(20) NOT NULL,
`passPortNumber` varchar(20) NULL,
`paymentStartDate` date NOT NULL,
`NumberOfInstallment` bigint(10) NOT NULL,
`totalAmount` DOUBLE(20,2) NOT NULL,
`estMonthlyInstallment` bigint(20) NULL,
`fundAllocationCash` bit(1) default null,
`fundAllocationBooks` bit(1) default null,
`fundAllocationMeals` bit(1) default null,
`fundAllocationAccommodation` bit(1) default null,
`accommodationProviderId` bigint(20) NULL,
`transactionTypeNew` bit(1) default null,
`TransactionTypeAdditional` bit(1) default null,
`TransactionTypeSubstract` bit(1) default null,
`TransactionTypeStop` bit(1) default null,
`scholarshipId` bigint(20) NULL,
`allowanceProposedId` bigint(20) NULL,
`comments` varchar(750)  NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `FK_intelliMali_FK_accountingYearId` FOREIGN KEY (`accountingYearId`) REFERENCES `accounting_year` (`id`),
CONSTRAINT `FK_intelliMali_FK_instituteCSM` FOREIGN KEY (`instituteCSM`) REFERENCES `drop_down` (`id`),
CONSTRAINT `FK_intelliMali_FK_studentId` FOREIGN KEY (`studentId`) REFERENCES `users` (`id`),
CONSTRAINT `FK_intelliMali_FK_programId` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`),
CONSTRAINT `FK_intelliMali_FK_academyLocationId` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
CONSTRAINT `FK_intelliMali_FK_accommodationProviderId` FOREIGN KEY (`accommodationProviderId`) REFERENCES `accommodation_provider` (`id`),
CONSTRAINT `FK_intelliMali_FK_allowanceProposedId` FOREIGN KEY (`allowanceProposedId`) REFERENCES `drop_down` (`id`),
CONSTRAINT `FK_intelliMali_FK_scholarshipId` FOREIGN KEY (`scholarshipId`) REFERENCES `scholarship` (`id`),
CONSTRAINT `FK_intelliMali_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)) ;
END IF;


END $$
CALL V20230822122527__Create_InteliMali () $$ 
DROP PROCEDURE IF EXISTS V20230822122527__Create_InteliMali $$ 
DELIMITER ;