DELIMITER $$
DROP PROCEDURE IF EXISTS V20230908140601__Create_SJAddedStatusDetailsTable $$
CREATE PROCEDURE V20230908140601__Create_SJAddedStatusDetailsTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_journey_added_status_details')) THEN

CREATE TABLE `student_journey_added_status_details` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `studentJourneyAddedStatusId` BIGINT(20) NOT NULL,
  `studentJourneyId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_applicant_person_interventions_idx` (`studentJourneyAddedStatusId` ASC),
  INDEX `fk_applicant_person_Id_idx` (`studentJourneyId` ASC),
  INDEX `fk_applicant_person_interventions_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_student_journey_added_status_details_id`
    FOREIGN KEY (`studentJourneyAddedStatusId`)
    REFERENCES `student_journey_added_status` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_student_journey_added_status_details_studentJourneyid`
    FOREIGN KEY (`studentJourneyId`)
    REFERENCES `student_journey` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_student_journey_added_status_details_lastUpdateBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF;  


END $$
CALL V20230908140601__Create_SJAddedStatusDetailsTable () $$ 
DROP PROCEDURE IF EXISTS V20230908140601__Create_SJAddedStatusDetailsTable $$ 
DELIMITER ;