DELIMITER $$
DROP PROCEDURE IF EXISTS V20240220154314__Insert_JIT_HallTicket $$
CREATE PROCEDURE V20240220154314__Insert_JIT_HallTicket()
BEGIN
set  @JitHallTicket = (select max(id) from report_type where typeName='Hall Ticket');
IF NOT EXISTS (SELECT * FROM `report_template` WHERE templateCode = 'JIT_HALL_TICKET') THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@JitHallTicket, 'JIT_HALL_TICKET', 'JIT Hall Ticket', 'JIT_HALL_TICKET.png', 'CommonReport_JIT_HallTicket.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'JIT_HALL_TICKET.jasper', 'AcademiaLogo.png');
END IF;

IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'JIT_HALL_TICKET')) THEN 
set @H1 = (select max(id)  from report_template where templateCode ='JIT_HALL_TICKET');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_ADMITCARD')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_ADMITCARD', 'ADMIT CARD', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_EXAMINATION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_EXAMINATION', 'Name of the Examination', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_PROGRAMME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_PROGRAMME', 'Programme', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SEMESTER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SEMESTER', 'Semester', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_ENROLLMENT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_ENROLLMENT', 'Enrollment Number', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_STUDENT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_STUDENT', 'Name of Student', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_FATHERS_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_FATHERS_NAME', 'Father’s Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_MOTHERS_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_MOTHERS_NAME', 'Mother’s Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_ROLL_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_ROLL_NO', 'Roll No', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_COURSES_OFFERED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_COURSES_OFFERED', 'Courses Offered/Schedule', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_STUDENT_ID')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_STUDENT_ID', 'Student ID', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_PLACEOF_EXAM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_PLACEOF_EXAM', 'Place of Examination', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SRNO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SRNO', 'Sr. No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_COURSE_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_COURSE_NAME', 'Course Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_COURSE_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_COURSE_CODE', 'Course Code', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_ROOM_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_ROOM_NO', 'Room No.', '1', now());		
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_EXAMINATION_DATES')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_EXAMINATION_DATES', 'Date of Examination', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_EXAMINATION_TIME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_EXAMINATION_TIME', 'Timings of Examinations', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_INVIGILATOR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_INVIGILATOR', 'Signature of Invigilator', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SEAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SEAL', 'Attached Notes:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_EXAMINATION_CONTROLLER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_EXAMINATION_CONTROLLER', 'Controller of Examinations', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_NOTE1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_NOTE1', '1. Enter examination hall 15 minutes before the scheduled time. Students coming 30 minutes after the commencement of the examination will not be permitted to enter the examination hall or to write the exam.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_NOTE2')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_NOTE2', '2. Students must write their Roll number on the question paper before starting to attempt the same.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_NOTE3')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_NOTE3', '3. Occupy the assigned seats only as per the seating plan issued by COE office.', '1', now());
END IF;
 
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_NOTE4')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_NOTE4', '4. All the students must carry their University Identity Card. Without I-card along with hall ticket, no student will be permitted to enter the Exam Hall.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_NOTE5')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_NOTE5', '5. Read all instructions carefully written on the answer book & complete all entries of the cover page carefully. It is the responsibility of the student to fill all the particulars in the answer-booklet correctly.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_NOTE6')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_NOTE6', '6. The students should not carry any other material which may directly or indirectly amount to use of unfair means in the examination.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_NOTE7')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_NOTE7', '7. The flying squad is authorized to conduct a thorough physical check of clothes, shoes etc. during the examination.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_NOTE8')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_NOTE8', '8. The candidate shall not write his/her name or leave any identification mark in the answer booklet. Any such act will be deemed to be use of unfair means.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_NOTE9')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_NOTE9', '9. Students are not allowed to leave the examination hall without the permission of invigilator even after time is over.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_NOTE10')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_NOTE10', '10. Writing anything on the desks or walls of the exam hall/room is also considered as malpractice.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_NOTE11')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_NOTE11', '11. Carrying programmable calculators, electronic gadgets, mobile phones & books into the examination hall is also considered as malpractice.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_NOTE12')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_NOTE12', '12. If a candidate is caught resorting to UFM, he/she will be provided with a new answer booklet to continue his/her examination. Candidates need not repeat answers which he/she had already answered in the first answer booklet.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_NOTE13')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_NOTE13', '13. Students must not write anything else on the question paper. Any rough work be done on the last page of the answer Booklet.', '1', now());
END IF;

END IF;
END $$
CALL V20240220154314__Insert_JIT_HallTicket() $$
DROP PROCEDURE IF EXISTS V20240220154314__Insert_JIT_HallTicket $$
DELIMITER ;