DELIMITER $$
DROP PROCEDURE IF EXISTS fatchUsersToBePushInBB $$
CREATE PROCEDURE fatchUsersToBePushInBB(fromdate timestamp)
BEGIN

SELECT 
    user.id as id,
    user.code as userCode,
    user.printName as userName,
    user.firstName as given,
    user.lastName as family,
    user.middleName as middle,
    (case when user.emailId is null then (case when stuPer.emailId is not null then stuPer.emailId else staffPerson.emailId end) else user.emailId end) as email,
    (case when stuPer.birthDate is not null then stuPer.birthDate else staffPerson.birthDate end) as birthDate,
    (case when gen.itemValue is not null then gen.itemValue else staffGen.itemValue end) as gender,
    (case when stu.userId is not null then 'STUDENT' else 'FACULTY' end)  as role
FROM
    users AS user
        left JOIN
    students AS stu ON stu.userId = user.id
        left JOIN
    persons AS stuPer ON stuPer.id = stu.personId
        left JOIN
	gender as gen On gen.id = stuPer.genderId
        left JOIN
    staffs AS stf ON stf.userId = user.id
        left JOIN
    persons AS staffPerson ON staffPerson.id = stf.personId
        left JOIN
	gender as staffGen On staffGen.id = staffPerson.genderId
		left JOIN
    user_academy_locations AS ual ON ual.id = user.id
        left JOIN
    user_acad_loc_roles AS ualr ON ualr.userAcadLocationId = ual.id
        left JOIN
    roles AS role ON role.id = ualr.roleId
    where  user.lastUpdate > fromdate and (role.roleName in("STUDENT","FACULTY")or stf.whetherFaculty=true) group by user.id;

END $$ 
DELIMITER ;