DELIMITER $$
DROP PROCEDURE IF EXISTS V20240308124541__Update_ExternalExaminerDataProviderS $$
CREATE PROCEDURE V20240308124541__Update_ExternalExaminerDataProviderS()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode = 'EXTERNAL_EXAMINER_A_INFO')) THEN 
UPDATE dydt_data_line_item
SET sqlSelectQueryDef= "SELECT T1.id AS id,
T4.firstName AS external_examiner_a_first_name,
T4.middleName AS external_examiner_a_middle_name,
T4.lastName AS external_examiner_a_last_name,
T4.alternateEmailId AS external_examiner_a_alternative_email_id,
T4.emailId AS external_examiner_a_email_id,
T4.phoneNo AS external_examiner_a_telephone_no,
T4.mobileNumber AS external_examiner_a_mobile_no,
    CONCAT(T7.addressText,',',T9.countryName,',',T10.countryRegionName,',',T7.pincode,',') AS external_examiner_a_address,
T13.code AS external_examiner_a_id,
T11.salutationName AS external_examiner_a_title,
T12.itemValue AS external_examiner_a_gender,
T14.itemValue AS external_examiner_a_nationality,

T15.employer AS external_examiner_a_employer_or_institution,
T15.department AS external_examiner_a_department,
T15.designation AS external_examiner_a_position_or_occupation,
T15.areaOfExpertise AS external_examiner_a_area_of_expertise_or_specialisation,
T7.faxNumber AS external_examiner_a_fax_no,
T4.highestQualification AS external_examiner_a_highest_qualification,
T4.awardingInstitution AS external_examiner_a_awarding_institution,
T16.numberOfPhDsSupervisedOverLastFiveYears AS external_examiner_a_number_of_phds_supervised_over_the_last_5_years,
T16.numberOfPhDsCompleted AS external_examiner_a_number_of_phds_completed,
T16.numberOfCurrentPhDStudents AS external_examiner_a_number_of_current_phds_students,
T16.numberOfMasterDegreeSupervisedOverFiveYears AS external_examiner_a_number_of_masters_degrees_supervised_over_the_last_5_years,
T16.numberOfMasterDegreeCompleted AS external_examiner_a_number_of_masters_degrees_completed,
T16.numberOfCurrentMasterStudents AS external_examiner_a_number_of_current_masters_students,
T16.numberOfArticlesInPeerReviewedOrRefereedJournals AS external_examiner_a_number_of_articles_in_peer_reviewed_or_refereed_journals,
T16.numberOfArticlesInPeerReviewedOrRefereedJournalsAsFirst AS external_examiner_a_number_of_articles_in_peer_reviewed_or_refereed_journals_as_first_or_corresponding_author,
T16.numberOfPublishedConferencePapers AS external_examiner_a_number_of_published_conference_papers,
T16.numberOfPublishedConferencePapersAsFirst AS external_examiner_a_number_of_published_conference_papers_as_first_or_corresponding_author,
T16.numberOfConferencesAndSymposia AS external_examiner_a_number_of_conferences_and_symposia_oral_or_poster_presentations,
T16.numberOfConferencesAndSymposiaAsFirst AS external_examiner_a_number_of_conferences_and_symposia_oral_or_poster_presentations_as_first_or_corresponding_author,
T16.scopusGoogleProfileOfExternalExaminer AS external_examiner_a_scopus_or_google_profile,
T16.deviationFromNormalRequirements AS external_examiner_a_motivate_deviation_from_normal_requirements,
T16.nominationOfExternalExaminer AS external_examiner_a_nomination_of_external_examiner,
T16.numberOfPHDsExamined AS external_examiner_a_number_of_phds_examined,
T16.numberOfMastersExamined AS external_examiner_a_number_of_masters_examined,
T16.nominationOfInternationalExaminer AS external_examiner_a_nomination_of_international_examiner,
T16.amendmentOfExaminer AS external_examiner_a_amendment_of_examiner,
T16.scopusGoogleProfileOfExternalExaminer as Google_Profile_Of_External_Examiner_a


from admission
left join users T1 on T1.id=admission.studentId
left join students T2 on T2.userId=T1.id
left join nominate_examiners T3 on T3.personId=T2.personId
left join examiner_type on examiner_type.id=T3.examinerType 
left join staffs T5 on T5.userId=T3.examinerName and examiner_type.itemCode='External Examiner A'
left join  persons T4 on T4.id=T5.personId
left join person_addresses T6  on T6.personId=T5.personId and T6.addressTypeId=5
left join address T7 on T7.id=T6.addressId
left join city T8 on T8.id=T7.cityId
left join country T9 on T9.id=T8.countryId
left join country_region T10 on T10.id=T8.countryRegionId
left join salutations T11 on T11.id=T4.salutationId
left join gender T12 on T12.id=T4.genderId
left join users T13 on T13.id =T3.personId
left join nationalities T14 on T14.id =T4.nationalityId
left join work_experience T15 on T15.personId=T5.personId
left join employees_additional_information T16 on T16.userId=T5.userId"
,resultColumnsDef="external_examiner_a_first_name,external_examiner_a_middle_name,external_examiner_a_last_name,external_examiner_a_address,external_examiner_a_email_id,external_examiner_a_alternative_email_id,external_examiner_a_telephone_no,external_examiner_a_mobile_no,external_examiner_a_id,external_examiner_a_title,external_examiner_a_gender,external_examiner_a_nationality,external_examiner_a_employer_or_institution,external_examiner_a_department,external_examiner_a_position_or_occupation,external_examiner_a_area_of_expertise_or_specialisation,external_examiner_a_fax_no,external_examiner_a_highest_qualification,external_examiner_a_awarding_institution,external_examiner_a_number_of_phds_supervised_over_the_last_5_years,external_examiner_a_number_of_phds_completed,external_examiner_a_number_of_current_phds_students,external_examiner_a_number_of_masters_degrees_supervised_over_the_last_5_years,external_examiner_a_number_of_masters_degrees_completed,external_examiner_a_number_of_current_masters_students,external_examiner_a_number_of_articles_in_peer_reviewed_or_refereed_journals,external_examiner_a_number_of_articles_in_peer_reviewed_or_refereed_journals_as_first_or_corresponding_author,external_examiner_a_number_of_published_conference_papers,external_examiner_a_number_of_published_conference_papers_as_first_or_corresponding_author,external_examiner_a_number_of_conferences_and_symposia_oral_or_poster_presentations,external_examiner_a_number_of_conferences_and_symposia_oral_or_poster_presentations_as_first_or_corresponding_author,external_examiner_a_scopus_or_google_profile,external_examiner_a_motivate_deviation_from_normal_requirements,external_examiner_a_nomination_of_external_examiner,external_examiner_a_number_of_phds_examined,external_examiner_a_number_of_masters_examined,external_examiner_a_nomination_of_international_examiner,external_examiner_a_amendment_of_examiner,Google_Profile_Of_External_Examiner_a",sqlWhereQueryDef="WHERE admission.id = PRM_ADMISSION_ID and examiner_type.itemCode='External Examiner A' order by T3.id  desc limit 1;"
WHERE dataSourceCode = 'EXTERNAL_EXAMINER_A_INFO';
END IF; 
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode = 'EXTERNAL_EXAMINER_B_INFO')) THEN 
UPDATE dydt_data_line_item
SET sqlSelectQueryDef= "SELECT T1.id AS id,
T4.firstName AS external_examiner_b_first_name,
T4.middleName AS external_examiner_b_middle_name,
T4.lastName AS external_examiner_b_last_name,
T4.alternateEmailId AS external_examiner_b_alternative_email_id,
T4.emailId AS external_examiner_b_email_id,
T4.phoneNo AS external_examiner_b_telephone_no,
T4.mobileNumber AS external_examiner_b_mobile_no,
    CONCAT(T7.addressText,',',T9.countryName,',',T10.countryRegionName,',',T7.pincode,',') AS external_examiner_b_address,
T13.code AS external_examiner_b_id,
T11.salutationName AS external_examiner_b_title,
T12.itemValue AS external_examiner_b_gender,
T14.itemValue AS external_examiner_b_nationality,
T15.employer AS external_examiner_b_employer_or_institution,
T15.department AS external_examiner_b_department,
T15.designation AS external_examiner_b_position_or_occupation,
T15.areaOfExpertise AS external_examiner_b_area_of_expertise_or_specialisation,
T7.faxNumber AS external_examiner_b_fax_no,
T4.highestQualification AS external_examiner_b_highest_qualification,
T4.awardingInstitution AS external_examiner_b_awarding_institution,
T16.numberOfPhDsSupervisedOverLastFiveYears AS external_examiner_b_number_of_phds_supervised_over_the_last_5_years,
T16.numberOfPhDsCompleted AS external_examiner_b_number_of_phds_completed,
T16.numberOfCurrentPhDStudents AS external_examiner_b_number_of_current_phds_students,
T16.numberOfMasterDegreeSupervisedOverFiveYears AS external_examiner_b_number_of_masters_degrees_supervised_over_the_last_5_years,
T16.numberOfMasterDegreeCompleted AS external_examiner_b_number_of_masters_degrees_completed,
T16.numberOfCurrentMasterStudents AS external_examiner_b_number_of_current_masters_students,
T16.numberOfArticlesInPeerReviewedOrRefereedJournals AS external_examiner_b_number_of_articles_in_peer_reviewed_or_refereed_journals,
T16.numberOfArticlesInPeerReviewedOrRefereedJournalsAsFirst AS external_examiner_b_number_of_articles_in_peer_reviewed_or_refereed_journals_as_first_or_corresponding_author,
T16.numberOfPublishedConferencePapers AS external_examiner_b_number_of_published_conference_papers,
T16.numberOfPublishedConferencePapersAsFirst AS external_examiner_b_number_of_published_conference_papers_as_first_or_corresponding_author,
T16.numberOfConferencesAndSymposia AS external_examiner_b_number_of_conferences_and_symposia_oral_or_poster_presentations,
T16.numberOfConferencesAndSymposiaAsFirst AS external_examiner_b_number_of_conferences_and_symposia_oral_or_poster_presentations_as_first_or_corresponding_author,
T16.scopusGoogleProfileOfExternalExaminer AS external_examiner_b_scopus_or_google_profile,
T16.deviationFromNormalRequirements AS external_examiner_b_motivate_deviation_from_normal_requirements,
T16.nominationOfExternalExaminer AS external_examiner_b_nomination_of_external_examiner,
T16.numberOfPHDsExamined AS external_examiner_b_number_of_phds_examined,
T16.numberOfMastersExamined AS external_examiner_b_number_of_masters_examined,
T16.nominationOfInternationalExaminer AS external_examiner_b_nomination_of_international_examiner,
T16.amendmentOfExaminer AS external_examiner_b_amendment_of_examiner,
T16.scopusGoogleProfileOfExternalExaminer as Google_Profile_Of_External_Examiner_b
from admission
left join users T1 on T1.id=admission.studentId
left join students T2 on T2.userId=T1.id
left join nominate_examiners T3 on T3.personId=T2.personId
left join examiner_type on examiner_type.id=T3.examinerType 
left join staffs T5 on T5.userId=T3.examinerName and examiner_type.itemCode='External Examiner B'
left join  persons T4 on T4.id=T5.personId
left join person_addresses T6  on T6.personId=T5.personId and T6.addressTypeId=5
left join address T7 on T7.id=T6.addressId
left join city T8 on T8.id=T7.cityId
left join country T9 on T9.id=T8.countryId
left join country_region T10 on T10.id=T8.countryRegionId
left join salutations T11 on T11.id=T4.salutationId
left join gender T12 on T12.id=T4.genderId
left join users T13 on T13.id =T3.personId
left join nationalities T14 on T14.id =T4.nationalityId
left join work_experience T15 on T15.personId=T4.id
left join employees_additional_information T16 on T16.userId=T5.userId"
,resultColumnsDef="external_examiner_b_first_name,external_examiner_b_middle_name,external_examiner_b_last_name,external_examiner_b_address,external_examiner_b_email_id,external_examiner_b_alternative_email_id,external_examiner_b_telephone_no,external_examiner_b_mobile_no,external_examiner_b_id,external_examiner_b_title,external_examiner_b_gender,external_examiner_b_nationality,external_examiner_b_employer_or_institution,external_examiner_b_department,external_examiner_b_position_or_occupation,external_examiner_b_area_of_expertise_or_specialisation,external_examiner_b_fax_no,external_examiner_b_highest_qualification,external_examiner_b_awarding_institution,external_examiner_b_number_of_phds_supervised_over_the_last_5_years,external_examiner_b_number_of_phds_completed,external_examiner_b_number_of_current_phds_students,external_examiner_b_number_of_masters_degrees_supervised_over_the_last_5_years,external_examiner_b_number_of_masters_degrees_completed,external_examiner_b_number_of_current_masters_students,external_examiner_b_number_of_articles_in_peer_reviewed_or_refereed_journals,external_examiner_b_number_of_articles_in_peer_reviewed_or_refereed_journals_as_first_or_corresponding_author,external_examiner_b_number_of_published_conference_papers,external_examiner_b_number_of_published_conference_papers_as_first_or_corresponding_author,external_examiner_b_number_of_conferences_and_symposia_oral_or_poster_presentations,external_examiner_b_number_of_conferences_and_symposia_oral_or_poster_presentations_as_first_or_corresponding_author,external_examiner_b_scopus_or_google_profile,external_examiner_b_motivate_deviation_from_normal_requirements,external_examiner_b_nomination_of_external_examiner,external_examiner_b_number_of_phds_examined,external_examiner_b_number_of_masters_examined,external_examiner_b_nomination_of_international_examiner,external_examiner_b_amendment_of_examiner,Google_Profile_Of_External_Examiner_b",sqlWhereQueryDef="WHERE admission.id = PRM_ADMISSION_ID and examiner_type.itemCode='External Examiner B' order by T3.id  desc limit 1;"
WHERE dataSourceCode = 'EXTERNAL_EXAMINER_B_INFO';

END IF; 
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode = 'EXTERNAL_EXAMINER_C_INFO')) THEN 
UPDATE dydt_data_line_item
SET sqlSelectQueryDef= "SELECT T1.id AS id,
T4.firstName AS external_examiner_c_first_name,
T4.middleName AS external_examiner_c_middle_name,
T4.lastName AS external_examiner_c_last_name,
T4.alternateEmailId AS external_examiner_c_alternative_email_id,
T4.emailId AS external_examiner_c_email_id,
T4.phoneNo AS external_examiner_c_telephone_no,
T4.mobileNumber AS external_examiner_c_mobile_no,
    CONCAT(T7.addressText,',',T9.countryName,',',T10.countryRegionName,',',T7.pincode,',') AS external_examiner_c_address,
T13.code AS external_examiner_c_id,
T11.salutationName AS external_examiner_c_title,
T12.itemValue AS external_examiner_c_gender,
T14.itemValue AS external_examiner_c_nationality,
T15.employer AS external_examiner_c_employer_or_institution,
T15.department AS external_examiner_c_department,
T15.designation AS external_examiner_c_position_or_occupation,
T15.areaOfExpertise AS external_examiner_c_area_of_expertise_or_specialisation,
T7.faxNumber AS external_examiner_c_fax_no,
T4.highestQualification AS external_examiner_c_highest_qualification,
T4.awardingInstitution AS external_examiner_c_awarding_institution,
T16.numberOfPhDsSupervisedOverLastFiveYears AS external_examiner_c_number_of_phds_supervised_over_the_last_5_years,
T16.numberOfPhDsCompleted AS external_examiner_c_number_of_phds_completed,
T16.numberOfCurrentPhDStudents AS external_examiner_c_number_of_current_phds_students,
T16.numberOfMasterDegreeSupervisedOverFiveYears AS external_examiner_c_number_of_masters_degrees_supervised_over_the_last_5_years,
T16.numberOfMasterDegreeCompleted AS external_examiner_c_number_of_masters_degrees_completed,
T16.numberOfCurrentMasterStudents AS external_examiner_c_number_of_current_masters_students,
T16.numberOfArticlesInPeerReviewedOrRefereedJournals AS external_examiner_c_number_of_articles_in_peer_reviewed_or_refereed_journals,
T16.numberOfArticlesInPeerReviewedOrRefereedJournalsAsFirst AS external_examiner_c_number_of_articles_in_peer_reviewed_or_refereed_journals_as_first_or_corresponding_author,
T16.numberOfPublishedConferencePapers AS external_examiner_c_number_of_published_conference_papers,
T16.numberOfPublishedConferencePapersAsFirst AS external_examiner_c_number_of_published_conference_papers_as_first_or_corresponding_author,
T16.numberOfConferencesAndSymposia AS external_examiner_c_number_of_conferences_and_symposia_oral_or_poster_presentations,
T16.numberOfConferencesAndSymposiaAsFirst AS external_examiner_c_number_of_conferences_and_symposia_oral_or_poster_presentations_as_first_or_corresponding_author,
T16.scopusGoogleProfileOfExternalExaminer AS external_examiner_c_scopus_or_google_profile,
T16.deviationFromNormalRequirements AS external_examiner_c_motivate_deviation_from_normal_requirements,
T16.nominationOfExternalExaminer AS external_examiner_c_nomination_of_external_examiner,
T16.numberOfPHDsExamined AS external_examiner_c_number_of_phds_examined,
T16.numberOfMastersExamined AS external_examiner_c_number_of_masters_examined,
T16.nominationOfInternationalExaminer AS external_examiner_c_nomination_of_international_examiner,
T16.amendmentOfExaminer AS external_examiner_c_amendment_of_examiner,
T16.scopusGoogleProfileOfExternalExaminer as Google_Profile_Of_External_Examiner_c
from admission
left join users T1 on T1.id=admission.studentId
left join students T2 on T2.userId=T1.id
left join nominate_examiners T3 on T3.personId=T2.personId
left join examiner_type on examiner_type.id=T3.examinerType 
left join staffs T5 on T5.userId=T3.examinerName and examiner_type.itemCode='External Examiner C'
left join  persons T4 on T4.id=T5.personId
left join person_addresses T6  on T6.personId=T5.personId and T6.addressTypeId=5
left join address T7 on T7.id=T6.addressId
left join city T8 on T8.id=T7.cityId
left join country T9 on T9.id=T8.countryId
left join country_region T10 on T10.id=T8.countryRegionId
left join salutations T11 on T11.id=T4.salutationId
left join gender T12 on T12.id=T4.genderId
left join users T13 on T13.id =T3.personId
left join nationalities T14 on T14.id =T4.nationalityId
left join work_experience T15 on T15.personId=T4.id
left join employees_additional_information T16 on T16.userId=T5.userId"
,resultColumnsDef="external_examiner_c_first_name,external_examiner_c_middle_name,external_examiner_c_last_name,external_examiner_c_address,external_examiner_c_email_id,external_examiner_c_alternative_email_id,external_examiner_c_telephone_no,external_examiner_c_mobile_no,external_examiner_c_id,external_examiner_c_title,external_examiner_c_gender,external_examiner_c_nationality,external_examiner_c_employer_or_institution,external_examiner_c_department,external_examiner_c_position_or_occupation,external_examiner_c_area_of_expertise_or_specialisation,external_examiner_c_fax_no,external_examiner_c_highest_qualification,external_examiner_c_awarding_institution,external_examiner_c_number_of_phds_supervised_over_the_last_5_years,external_examiner_c_number_of_phds_completed,external_examiner_c_number_of_current_phds_students,external_examiner_c_number_of_masters_degrees_supervised_over_the_last_5_years,external_examiner_c_number_of_masters_degrees_completed,external_examiner_c_number_of_current_masters_students,external_examiner_c_number_of_articles_in_peer_reviewed_or_refereed_journals,external_examiner_c_number_of_articles_in_peer_reviewed_or_refereed_journals_as_first_or_corresponding_author,external_examiner_c_number_of_published_conference_papers,external_examiner_c_number_of_published_conference_papers_as_first_or_corresponding_author,external_examiner_c_number_of_conferences_and_symposia_oral_or_poster_presentations,external_examiner_c_number_of_conferences_and_symposia_oral_or_poster_presentations_as_first_or_corresponding_author,external_examiner_c_scopus_or_google_profile,external_examiner_c_motivate_deviation_from_normal_requirements,external_examiner_c_nomination_of_external_examiner,external_examiner_c_number_of_phds_examined,external_examiner_c_number_of_masters_examined,external_examiner_c_nomination_of_international_examiner,external_examiner_c_amendment_of_examiner,Google_Profile_Of_External_Examiner_c",sqlWhereQueryDef="WHERE admission.id = PRM_ADMISSION_ID and examiner_type.itemCode='External Examiner C' order by T3.id  desc limit 1;"
WHERE dataSourceCode = 'EXTERNAL_EXAMINER_C_INFO';

END IF; 
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode = 'EXTERNAL_EXAMINER_D_INFO')) THEN 
UPDATE dydt_data_line_item
SET sqlSelectQueryDef= "SELECT T1.id AS id,
T4.firstName AS external_examiner_d_first_name,
T4.middleName AS external_examiner_d_middle_name,
T4.lastName AS external_examiner_d_last_name,
T4.alternateEmailId AS external_examiner_d_alternative_email_id,
T4.emailId AS external_examiner_d_email_id,
T4.phoneNo AS external_examiner_d_telephone_no,
T4.mobileNumber AS external_examiner_d_mobile_no,
    CONCAT(T7.addressText,',',T9.countryName,',',T10.countryRegionName,',',T7.pincode,',') AS external_examiner_d_address,
T13.code AS external_examiner_d_id,
T11.salutationName AS external_examiner_d_title,
T12.itemValue AS external_examiner_d_gender,
T14.itemValue AS external_examiner_d_nationality,
T15.employer AS external_examiner_d_employer_or_institution,
T15.department AS external_examiner_d_department,
T15.designation AS external_examiner_d_position_or_occupation,
T15.areaOfExpertise AS external_examiner_d_area_of_expertise_or_specialisation,
T7.faxNumber AS external_examiner_d_fax_no,
T4.highestQualification AS external_examiner_d_highest_qualification,
T4.awardingInstitution AS external_examiner_d_awarding_institution,
T16.numberOfPhDsSupervisedOverLastFiveYears AS external_examiner_d_number_of_phds_supervised_over_the_last_5_years,
T16.numberOfPhDsCompleted AS external_examiner_d_number_of_phds_completed,
T16.numberOfCurrentPhDStudents AS external_examiner_d_number_of_current_phds_students,
T16.numberOfMasterDegreeSupervisedOverFiveYears AS external_examiner_d_number_of_masters_degrees_supervised_over_the_last_5_years,
T16.numberOfMasterDegreeCompleted AS external_examiner_d_number_of_masters_degrees_completed,
T16.numberOfCurrentMasterStudents AS external_examiner_d_number_of_current_masters_students,
T16.numberOfArticlesInPeerReviewedOrRefereedJournals AS external_examiner_d_number_of_articles_in_peer_reviewed_or_refereed_journals,
T16.numberOfArticlesInPeerReviewedOrRefereedJournalsAsFirst AS external_examiner_d_number_of_articles_in_peer_reviewed_or_refereed_journals_as_first_or_corresponding_author,
T16.numberOfPublishedConferencePapers AS external_examiner_d_number_of_published_conference_papers,
T16.numberOfPublishedConferencePapersAsFirst AS external_examiner_d_number_of_published_conference_papers_as_first_or_corresponding_author,
T16.numberOfConferencesAndSymposia AS external_examiner_d_number_of_conferences_and_symposia_oral_or_poster_presentations,
T16.numberOfConferencesAndSymposiaAsFirst AS external_examiner_d_number_of_conferences_and_symposia_oral_or_poster_presentations_as_first_or_corresponding_author,
T16.scopusGoogleProfileOfExternalExaminer AS external_examiner_d_scopus_or_google_profile,
T16.deviationFromNormalRequirements AS external_examiner_d_motivate_deviation_from_normal_requirements,
T16.nominationOfExternalExaminer AS external_examiner_d_nomination_of_external_examiner,
T16.numberOfPHDsExamined AS external_examiner_d_number_of_phds_examined,
T16.numberOfMastersExamined AS external_examiner_d_number_of_masters_examined,
T16.nominationOfInternationalExaminer AS external_examiner_d_nomination_of_international_examiner,
T16.amendmentOfExaminer AS external_examiner_d_amendment_of_examiner,
T16.scopusGoogleProfileOfExternalExaminer as Google_Profile_Of_External_Examiner_d
from admission
left join users T1 on T1.id=admission.studentId
left join students T2 on T2.userId=T1.id
left join nominate_examiners T3 on T3.personId=T2.personId
left join examiner_type on examiner_type.id=T3.examinerType 
left join staffs T5 on T5.userId=T3.examinerName and examiner_type.itemCode='External Examiner D'
left join  persons T4 on T4.id=T5.personId
left join person_addresses T6  on T6.personId=T5.personId and T6.addressTypeId=5
left join address T7 on T7.id=T6.addressId
left join city T8 on T8.id=T7.cityId
left join country T9 on T9.id=T8.countryId
left join country_region T10 on T10.id=T8.countryRegionId
left join salutations T11 on T11.id=T4.salutationId
left join gender T12 on T12.id=T4.genderId
left join users T13 on T13.id =T3.personId
left join nationalities T14 on T14.id =T4.nationalityId
left join work_experience T15 on T15.personId=T4.id
left join employees_additional_information T16 on T16.userId=T5.userId"
,resultColumnsDef="external_examiner_d_first_name,external_examiner_d_middle_name,external_examiner_d_last_name,external_examiner_d_address,external_examiner_d_email_id,external_examiner_d_alternative_email_id,external_examiner_d_telephone_no,external_examiner_d_mobile_no,external_examiner_d_id,external_examiner_d_title,external_examiner_d_gender,external_examiner_d_nationality,external_examiner_d_employer_or_institution,external_examiner_d_department,external_examiner_d_position_or_occupation,external_examiner_d_area_of_expertise_or_specialisation,external_examiner_d_fax_no,external_examiner_d_highest_qualification,external_examiner_d_awarding_institution,external_examiner_d_number_of_phds_supervised_over_the_last_5_years,external_examiner_d_number_of_phds_completed,external_examiner_d_number_of_current_phds_students,external_examiner_d_number_of_masters_degrees_supervised_over_the_last_5_years,external_examiner_d_number_of_masters_degrees_completed,external_examiner_d_number_of_current_masters_students,external_examiner_d_number_of_articles_in_peer_reviewed_or_refereed_journals,external_examiner_d_number_of_articles_in_peer_reviewed_or_refereed_journals_as_first_or_corresponding_author,external_examiner_d_number_of_published_conference_papers,external_examiner_d_number_of_published_conference_papers_as_first_or_corresponding_author,external_examiner_d_number_of_conferences_and_symposia_oral_or_poster_presentations,external_examiner_d_number_of_conferences_and_symposia_oral_or_poster_presentations_as_first_or_corresponding_author,external_examiner_d_scopus_or_google_profile,external_examiner_d_motivate_deviation_from_normal_requirements,external_examiner_d_nomination_of_external_examiner,external_examiner_d_number_of_phds_examined,external_examiner_d_number_of_masters_examined,,external_examiner_d_nomination_of_international_examiner,external_examiner_d_amendment_of_examiner,Google_Profile_Of_External_Examiner_d",sqlWhereQueryDef="WHERE admission.id = PRM_ADMISSION_ID and examiner_type.itemCode='External Examiner D' order by T3.id  desc limit 1;"
WHERE dataSourceCode = 'EXTERNAL_EXAMINER_D_INFO';
END IF; 
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode = 'INTERNAL_EXAMINER_A_INFO')) THEN 
UPDATE dydt_data_line_item
SET sqlSelectQueryDef= "SELECT T1.id AS id,
T4.firstName AS internal_examiner_a_first_name,
T4.middleName AS internal_examiner_a_middle_name,
T4.lastName AS internal_examiner_a_last_name,
T4.alternateEmailId AS internal_examiner_a_alternative_email_id,
T4.emailId AS internal_examiner_a_email_id,
T4.phoneNo AS internal_examiner_a_telephone_no,
T4.mobileNumber AS internal_examiner_a_mobile_no,
    CONCAT(T7.addressText,',',T9.countryName,',',T10.countryRegionName,',',T7.pincode,',') AS internal_examiner_a_address,
T13.code AS internal_examiner_a_id,
T11.salutationName AS internal_examiner_a_title,
T12.itemValue AS internal_examiner_a_gender,
T14.itemValue AS internal_examiner_a_nationality,

T15.employer AS internal_examiner_a_employer_or_institution,
T15.department AS internal_examiner_a_department,
T15.designation AS internal_examiner_a_position_or_occupation,
T15.areaOfExpertise AS internal_examiner_a_area_of_expertise_or_specialisation,
T7.faxNumber AS internal_examiner_a_fax_no,
T4.highestQualification AS internal_examiner_a_highest_qualification,
T4.awardingInstitution AS internal_examiner_a_awarding_institution,
T16.numberOfPhDsSupervisedOverLastFiveYears AS internal_examiner_a_number_of_phds_supervised_over_the_last_5_years,
T16.numberOfPhDsCompleted AS internal_examiner_a_number_of_phds_completed,
T16.numberOfCurrentPhDStudents AS internal_examiner_a_number_of_current_phds_students,
T16.numberOfMasterDegreeSupervisedOverFiveYears AS internal_examiner_a_number_of_masters_degrees_supervised_over_the_last_5_years,
T16.numberOfMasterDegreeCompleted AS internal_examiner_a_number_of_masters_degrees_completed,
T16.numberOfCurrentMasterStudents AS internal_examiner_a_number_of_current_masters_students,
T16.numberOfArticlesInPeerReviewedOrRefereedJournals AS internal_examiner_a_number_of_articles_in_peer_reviewed_or_refereed_journals,
T16.numberOfArticlesInPeerReviewedOrRefereedJournalsAsFirst AS internal_examiner_a_number_of_articles_in_peer_reviewed_or_refereed_journals_as_first_or_corresponding_author,
T16.numberOfPublishedConferencePapers AS internal_examiner_a_number_of_published_conference_papers,
T16.numberOfPublishedConferencePapersAsFirst AS internal_examiner_a_number_of_published_conference_papers_as_first_or_corresponding_author,
T16.numberOfConferencesAndSymposia AS internal_examiner_a_number_of_conferences_and_symposia_oral_or_poster_presentations,
T16.numberOfConferencesAndSymposiaAsFirst AS internal_examiner_a_number_of_conferences_and_symposia_oral_or_poster_presentations_as_first_or_corresponding_author,
T16.deviationFromNormalRequirements AS internal_examiner_a_motivate_deviation_from_normal_requirements,
T16.nominationOfExternalExaminer AS external_examiner_a_nomination_of_external_examiner,
T16.nominationOfInternalExaminer AS internal_examiner_a_nomination_of_external_examiner,
T16.numberOfPHDsExamined AS internal_examiner_a_number_of_phds_examined,
T16.numberOfMastersExamined AS internal_examiner_a_number_of_masters_examined,
T16.nominationOfInternationalExaminer AS internal_examiner_a_nomination_of_international_examiner,
T16.amendmentOfExaminer AS internal_examiner_a_amendment_of_examiner,
T16.scopusGoogleProfileOfExternalExaminer as Google_Profile_Of_Internal_Examiner_a




from admission
left join users T1 on T1.id=admission.studentId
left join students T2 on T2.userId=T1.id
left join nominate_examiners T3 on T3.personId=T2.personId
left join examiner_type on examiner_type.id=T3.examinerType 
left join staffs T5 on T5.userId=T3.examinerName and examiner_type.itemCode='Internal Examiner A'
left join  persons T4 on T4.id=T5.personId
left join person_addresses T6  on T6.personId=T5.personId and T6.addressTypeId=5
left join address T7 on T7.id=T6.addressId
left join city T8 on T8.id=T7.cityId
left join country T9 on T9.id=T8.countryId
left join country_region T10 on T10.id=T8.countryRegionId
left join salutations T11 on T11.id=T4.salutationId
left join gender T12 on T12.id=T4.genderId
left join users T13 on T13.id =T3.personId
left join nationalities T14 on T14.id =T4.nationalityId
left join work_experience T15 on T15.personId=T5.personId
left join employees_additional_information T16 on T16.userId=T5.userId"
,resultColumnsDef="internal_examiner_a_first_name,internal_examiner_a_middle_name,internal_examiner_a_last_name,internal_examiner_a_address,internal_examiner_a_email_id,internal_examiner_a_alternative_email_id,internal_examiner_a_telephone_no,internal_examiner_a_mobile_no,internal_examiner_a_id,internal_examiner_a_title,internal_examiner_a_gender,internal_examiner_a_nationality,internal_examiner_a_employer_or_institution,internal_examiner_a_department,internal_examiner_a_position_or_occupation,internal_examiner_a_area_of_expertise_or_specialisation,internal_examiner_a_fax_no,internal_examiner_a_highest_qualification,internal_examiner_a_awarding_institution,internal_examiner_a_number_of_phds_supervised_over_the_last_5_years,internal_examiner_a_number_of_phds_completed,internal_examiner_a_number_of_current_phds_students,internal_examiner_a_number_of_masters_degrees_supervised_over_the_last_5_years,internal_examiner_a_number_of_masters_degrees_completed,internal_examiner_a_number_of_current_masters_students,internal_examiner_a_number_of_articles_in_peer_reviewed_or_refereed_journals,internal_examiner_a_number_of_articles_in_peer_reviewed_or_refereed_journals_as_first_or_corresponding_author,internal_examiner_a_number_of_published_conference_papers,internal_examiner_a_number_of_published_conference_papers_as_first_or_corresponding_author,internal_examiner_a_number_of_conferences_and_symposia_oral_or_poster_presentations,internal_examiner_a_number_of_conferences_and_symposia_oral_or_poster_presentations_as_first_or_corresponding_author,internal_examiner_a_motivate_deviation_from_normal_requirements,external_examiner_a_nomination_of_external_examiner,internal_examiner_a_nomination_of_external_examiner,internal_examiner_a_number_of_phds_examined,internal_examiner_a_number_of_masters_examined,internal_examiner_a_nomination_of_international_examiner,internal_examiner_a_amendment_of_examiner,Google_Profile_Of_Internal_Examiner_a",sqlWhereQueryDef="WHERE admission.id = PRM_ADMISSION_ID and examiner_type.itemCode='Internal Examiner A' order by T3.id  desc limit 1;"
WHERE dataSourceCode = 'INTERNAL_EXAMINER_A_INFO';

END IF; 
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode = 'INTERNAL_EXAMINER_B_INFO')) THEN 
UPDATE dydt_data_line_item
SET sqlSelectQueryDef= "SELECT T1.id AS id,
T4.firstName AS internal_examiner_b_first_name,
T4.middleName AS internal_examiner_b_middle_name,
T4.lastName AS internal_examiner_b_last_name,
T4.alternateEmailId AS internal_examiner_b_alternative_email_id,
T4.emailId AS internal_examiner_b_email_id,
T4.phoneNo AS internal_examiner_b_telephone_no,
T4.mobileNumber AS internal_examiner_b_mobile_no,
    CONCAT(T7.addressText,',',T9.countryName,',',T10.countryRegionName,',',T7.pincode,',') AS internal_examiner_b_address,
T13.code AS internal_examiner_b_id,
T11.salutationName AS internal_examiner_b_title,
T12.itemValue AS internal_examiner_b_gender,
T14.itemValue AS internal_examiner_b_nationality,

T15.employer AS internal_examiner_b_employer_or_institution,
T15.department AS internal_examiner_b_department,
T15.designation AS internal_examiner_b_position_or_occupation,
T15.areaOfExpertise AS internal_examiner_b_area_of_expertise_or_specialisation,
T7.faxNumber AS internal_examiner_b_fax_no,
T4.highestQualification AS internal_examiner_b_highest_qualification,
T4.awardingInstitution AS internal_examiner_b_awarding_institution,
T16.numberOfPhDsSupervisedOverLastFiveYears AS internal_examiner_b_number_of_phds_supervised_over_the_last_5_years,
T16.numberOfPhDsCompleted AS internal_examiner_b_number_of_phds_completed,
T16.numberOfCurrentPhDStudents AS internal_examiner_b_number_of_current_phds_students,
T16.numberOfMasterDegreeSupervisedOverFiveYears AS internal_examiner_b_number_of_masters_degrees_supervised_over_the_last_5_years,
T16.numberOfMasterDegreeCompleted AS internal_examiner_b_number_of_masters_degrees_completed,
T16.numberOfCurrentMasterStudents AS internal_examiner_b_number_of_current_masters_students,
T16.numberOfArticlesInPeerReviewedOrRefereedJournals AS internal_examiner_b_number_of_articles_in_peer_reviewed_or_refereed_journals,
T16.numberOfArticlesInPeerReviewedOrRefereedJournalsAsFirst AS internal_examiner_b_number_of_articles_in_peer_reviewed_or_refereed_journals_as_first_or_corresponding_author,
T16.numberOfPublishedConferencePapers AS internal_examiner_b_number_of_published_conference_papers,
T16.numberOfPublishedConferencePapersAsFirst AS internal_examiner_b_number_of_published_conference_papers_as_first_or_corresponding_author,
T16.numberOfConferencesAndSymposia AS internal_examiner_b_number_of_conferences_and_symposia_oral_or_poster_presentations,
T16.numberOfConferencesAndSymposiaAsFirst AS internal_examiner_b_number_of_conferences_and_symposia_oral_or_poster_presentations_as_first_or_corresponding_author,
T16.deviationFromNormalRequirements AS internal_examiner_b_motivate_deviation_from_normal_requirements,
T16.nominationOfExternalExaminer AS internal_examiner_b_nomination_of_external_examiner,
T16.numberOfPHDsExamined AS internal_examiner_b_number_of_phds_examined,
T16.numberOfMastersExamined AS internal_examiner_b_number_of_masters_examined,
T16.nominationOfInternationalExaminer AS internal_examiner_b_nomination_of_international_examiner,
T16.amendmentOfExaminer AS internal_examiner_b_amendment_of_examiner,
T16.scopusGoogleProfileOfExternalExaminer as Google_Profile_Of_Internal_Examiner_b

from admission
left join users T1 on T1.id=admission.studentId
left join students T2 on T2.userId=T1.id
left join nominate_examiners T3 on T3.personId=T2.personId
left join examiner_type on examiner_type.id=T3.examinerType 
left join staffs T5 on T5.userId=T3.examinerName and examiner_type.itemCode='Internal Examiner B'
left join  persons T4 on T4.id=T5.personId
left join person_addresses T6  on T6.personId=T5.personId and T6.addressTypeId=5
left join address T7 on T7.id=T6.addressId
left join city T8 on T8.id=T7.cityId
left join country T9 on T9.id=T8.countryId
left join country_region T10 on T10.id=T8.countryRegionId
left join salutations T11 on T11.id=T4.salutationId
left join gender T12 on T12.id=T4.genderId
left join users T13 on T13.id =T3.personId
left join nationalities T14 on T14.id =T4.nationalityId
left join work_experience T15 on T15.personId=T5.personId
left join employees_additional_information T16 on T16.userId=T5.userId"
,resultColumnsDef="internal_examiner_b_first_name,internal_examiner_b_middle_name,internal_examiner_b_last_name,internal_examiner_b_address,internal_examiner_b_email_id,internal_examiner_b_alternative_email_id,internal_examiner_b_telephone_no,internal_examiner_b_mobile_no,internal_examiner_b_id,internal_examiner_b_title,internal_examiner_b_gender,internal_examiner_b_nationality,internal_examiner_b_employer_or_institution,internal_examiner_b_department,internal_examiner_b_position_or_occupation,internal_examiner_b_area_of_expertise_or_specialisation,internal_examiner_b_fax_no,internal_examiner_b_highest_qualification,internal_examiner_b_awarding_institution,internal_examiner_b_number_of_phds_supervised_over_the_last_5_years,internal_examiner_b_number_of_phds_completed,internal_examiner_b_number_of_current_phds_students,internal_examiner_b_number_of_masters_degrees_supervised_over_the_last_5_years,internal_examiner_b_number_of_masters_degrees_completed,internal_examiner_b_number_of_current_masters_students,internal_examiner_b_number_of_articles_in_peer_reviewed_or_refereed_journals,internal_examiner_b_number_of_articles_in_peer_reviewed_or_refereed_journals_as_first_or_corresponding_author,internal_examiner_b_number_of_published_conference_papers,internal_examiner_b_number_of_published_conference_papers_as_first_or_corresponding_author,internal_examiner_b_number_of_conferences_and_symposia_oral_or_poster_presentations,internal_examiner_b_number_of_conferences_and_symposia_oral_or_poster_presentations_as_first_or_corresponding_author,internal_examiner_b_motivate_deviation_from_normal_requirements,internal_examiner_b_nomination_of_external_examiner,internal_examiner_b_number_of_phds_examined,internal_examiner_b_number_of_masters_examined,internal_examiner_b_nomination_of_international_examiner,internal_examiner_b_amendment_of_examiner,Google_Profile_Of_Internal_Examiner_b",sqlWhereQueryDef="WHERE admission.id = PRM_ADMISSION_ID and examiner_type.itemCode='Internal Examiner B' order by T3.id  desc limit 1;"
WHERE dataSourceCode = 'INTERNAL_EXAMINER_B_INFO';

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240308124541__Update_ExternalExaminerDataProviderS () $$
DROP PROCEDURE IF EXISTS V20240308124541__Update_ExternalExaminerDataProviderS $$
DELIMITER ;