DELIMITER $$
DROP PROCEDURE IF EXISTS V20240311120930__Create_Create_moodle_user $$
CREATE PROCEDURE V20240311120930__Create_Create_moodle_user()
BEGIN


IF EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='moodle_user') THEN 
drop view moodle_user;
END IF; 
IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='moodle_user') THEN
create view moodle_user as select u.id as userid, u.code as usercode, u.firstName as firstname,u.lastName as lastname, u.emailId as emailid, mti.moodleId as moodleid,'STUDENT' as usertype, u.lastUpdate as lastupdate, a.academyLocationId as academylocationid 
from users u
join admission a on u.id = a.studentId
left join moodle_transaction_info mti on u.id = mti.academiaId and mti.moodleTransactionType='STUDENT'
where  u.userGroupId =3
and u.status=true and a.activeStatus=true
union all
select u.id as userid, u.code as usercode, u.firstName as firstname,u.lastName as lastname, u.emailId as emailid, mti.moodleId as moodleid,'FACULTY' as usertype, u.lastUpdate as lastupdate, ual.academyLocationId as academylocationid  
from users u
join user_academy_locations ual on u.id = ual.userId
left join moodle_transaction_info mti on u.id = mti.academiaId and mti.moodleTransactionType='FACULTY'
where  u.userGroupId =2
and u.status=true;
END IF; 

END $$
CALL V20240311120930__Create_Create_moodle_user () $$ 
DROP PROCEDURE IF EXISTS V20240311120930__Create_Create_moodle_user $$ 
DELIMITER ;