DELIMITER $$
DROP PROCEDURE IF EXISTS V20240315110000__student_course_mapping $$
CREATE PROCEDURE V20240315110000__student_course_mapping()
BEGIN

IF EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_course_mapping') THEN 
drop view student_course_mapping;
END IF; 

create view student_course_mapping as select mti.academiaId as user_academiaid,  mti.moodleId as user_moodleid, 5 as moodle_roleid, mc.academiaCourseVariantId as academia_course_variantid,  mc.moodleCourseId as course_moodleid, 
mc.academyLocationId as academylocationid , a.lastUpdate as detail_lastupdate1, en.lastUpdate as detail_lastupdate2 
from admission a 
join student_course_enrollment en on a.id=en.admissionId and en.exitDate is null and en.isCurrentSection =1
join moodle_transaction_info mti on mti.academiaId = a.studentId and mti.moodleTransactionType='STUDENT'
join moodle_course mc on en.courseVarientId=mc.academiaCourseVariantId and a.academyLocationId = mc.academyLocationId
left join moodle_user_course_mapping mcp on mti.moodleId=mcp.user_moodleid and mc.moodleCourseId=mcp.course_variant_moodleid
where mcp.id is null
union all
select mti.academiaId as academiaid, mti.moodleId as moodleid, 3 as moodle_roleid, mc.academiaCourseVariantId as academia_course_variantid,mc.moodleCourseId as moodle_courseid, 
mc.academyLocationId as academylocationid , pbcf.lastUpdate as detail_lastupdate1, pbcp.lastUpdate as detail_lastupdate2 
from prog_batch_course_faculty pbcf
join program_batch_course_param pbcp on pbcf.progBatchCourseParamId = pbcp.id
join moodle_course mc on pbcp.courseVarientId = mc.academiaCourseVariantId
join moodle_transaction_info mti on pbcf.facultyId = mti.academiaId and mti.moodleTransactionType='FACULTY'
left join moodle_user_course_mapping mcp on mti.moodleId=mcp.user_moodleid and mc.moodleCourseId=mcp.course_variant_moodleid
where mcp.id is null;


END $$
CALL V20240315110000__student_course_mapping () $$ 
DROP PROCEDURE IF EXISTS V20240315110000__student_course_mapping $$ 
DELIMITER ;