DELIMITER $$
DROP PROCEDURE IF EXISTS V20240315120000__Create_prog_cat_group_courses $$
CREATE PROCEDURE V20240315120000__Create_prog_cat_group_courses()
BEGIN

IF EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='prog_cat_group_courses') THEN 
drop view prog_cat_group_courses;
END IF; 
create view prog_cat_group_courses as 
select cv.id as id, p.academyLocationId as academy_location_id, pc.id as prog_cat_id, pc.categoryName as prog_cat_name, pc.lastUpdate as prog_cat_lastupdate,mpcat.moodleId as prog_cat_moodleid, mpcat.parentMoodleId as prog_cat_parent_moodleid,
pg.id as prog_group_id, pg.groupName as prog_group_name, pg.lastUpdate as prog_group_lastupdate,mpgroup.moodleId as prog_group_moodleid, mpgroup.parentMoodleId as prog_group_parent_moodleid,
p.id as prog_id, p.programCode as prog_code, p.programName as prog_name, p.lastUpdate as prog_lastupdate,mprog.moodleId as prog_moodleid,mprog.parentMoodleId as prog_parent_moodleid,
aterm.id as academic_term_id, aterm.itemValue  academic_term_name, aterm.lastUpdate as academic_term_lastupdate,macadtrm.moodleId as academic_term_moodleid,macadtrm.parentMoodleId as academic_term_parent_moodleid,
c.id as course_id, c.courseCode as course_code ,c.courseName as course_name, c.lastUpdate as course_lastupdate,mc.moodleId as course_moodleid,mc.parentMoodleId as course_parent_moodleid,
cv.id course_variant_id, param.sectionid as section_id, cv.courseVariantCode as course_variant_name, cv.lastUpdate as course_variant_lastupdate, mcv.moodleCourseId as course_variant_moodleid, mcv.parentMoodleId as course_variant_parent_moodleid 
from program_batch_course_param param
join batches b on param.programBatchId=b.id
join prog_batch_period_config period on param.progBatchPeriodConfigId = period.id and period.programBatchId = b.id
join academic_term aterm on period.academicTermId = aterm.id
join programs p on b.programId = p.id
join program_group pg on p.programGroupId = pg.id
join program_category pc on p.programCategoryId = pc.id
join courses c on param.courseId = c.id
join course_variants cv on param.courseVarientId = cv.id and cv.courseid=c.id and p.academyLocationId =  cv.academyLocationId 
left join moodle_transaction_info mpcat on mpcat.academiaId = pc.id and mpcat.moodleTransactionType='PROGRAM_CATEGORY' and mpcat.hierarchy = 'CAT_GROUP_PROGRAM_ACADEMICTERM_COURSE_VARIANT'
left join moodle_transaction_info mpgroup on mpgroup.academiaId = pg.id and mpgroup.parentAcademiaId = pc.id and mpcat.hierarchy = mpgroup.hierarchy and mpgroup.moodleTransactionType='PROGRAM_GROUP'
left join moodle_transaction_info mprog on mprog.academiaId = p.id and mprog.parentAcademiaId =  pg.id  and mpgroup.hierarchy = mprog.hierarchy and mprog.moodleTransactionType='PROGRAM'
left join moodle_transaction_info macadtrm on macadtrm.academiaId = aterm.id and macadtrm.parentAcademiaId = p.id and  mprog.hierarchy = macadtrm.hierarchy and macadtrm.moodleTransactionType='ACADEMIC_TERM'
left join moodle_transaction_info mc on mc.academiaId = c.id and mc.parentAcademiaId = aterm.id  and  macadtrm.hierarchy = mc.hierarchy and mc.moodleTransactionType='COURSE'
left join moodle_course mcv on mcv.academiaCourseVariantId = cv.id and mcv.sectionId=param.sectionId and mcv.parentAcademiaId = c.id and mc.hierarchy = mcv.hierarchy and  mcv.academyLocationId = p.academyLocationId;


END $$
CALL V20240315120000__Create_prog_cat_group_courses () $$ 
DROP PROCEDURE IF EXISTS V20240315120000__Create_prog_cat_group_courses $$ 
DELIMITER ;