DELIMITER $$
DROP PROCEDURE IF EXISTS V20240404125921__Update_OntheExpiryDateSatisfactionEvent $$
CREATE PROCEDURE V20240404125921__Update_OntheExpiryDateSatisfactionEvent()
BEGIN
SET SQL_SAFE_UPDATES=0;
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ON_THE_EXPIRY_DATE_OF_SATISFACTION_RCPNT');
IF EXISTS (((SELECT * FROM dtprovider WHERE `dataProviderName`='ON_THE_EXPIRY_DATE_OF_SATISFACTION_RCPNT'))) THEN 
UPDATE sql_dtprovider
SET sqlQuery="SELECT 
	p.id AS ID,
    T21.orgName AS Organization_Name,
    T25.countryName AS Organization_countryName,
    T26.countryRegionName AS Organization_countryRegionName,
    T24.cityName AS Organization_cityName,
    T23.pincode AS Organization_pincode,
    T23.postalCode AS Organization_postalCode,
    T23.phoneNo AS Organization_phoneNo,
    T23.cellNo AS Organization_cellNo,
    T23.primaryeEmailId AS Organization_primaryeEmailId,
    T17.locationName AS Academic_location,
    T15.countryName AS Academiclocation_countryName,
    T16.countryRegionName AS Academiclocation_countryRegionName,
    T14.cityName AS Academiclocation_cityName,
    T13.pincode AS Academiclocation_pincode,
    T13.postalCode AS Academiclocation_postalCode,
    T13.phoneNo AS Academiclocation_phoneNo,
    T13.cellNo AS Academiclocation_cellNo,
    T13.primaryeEmailId AS Academiclocation_primaryeEmailId,
    T3.code AS Student_ID,
    T10.salutationName AS Salutation,
    a.code AS Application_ID,
    T5.programCode AS Programme_Code,
    T7.shortCode AS Department_Code,
    T20.shortCode AS Subdepartment_Code,
    T28.printName AS Period_Name,
    DATE_FORMAT(DATE(NOW()), '%d-%m-%y') AS Curr_Date,
    T11.itemValue AS Student_Gender,
    T4.admissionDate AS Admission_date,
    T8.groupName AS Programme_Group,
    T1.nationalId AS Identity_No,
    T1.mobileNumber AS MOBILE_NO,
    T1.emailId AS EMAIL_ID,
    T1.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T1.printName AS Student_Name,
    T1.firstName AS FIRST_NAME,
    T1.middleName AS MIDDLE_NAME,
    T1.lastName AS LAST_NAME,
    T5.programNameToBePrint AS Programme_Name,
    T7.deptName AS Department_Name,
    T20.deptName AS Subdepartment_Name,
    T4.code AS Admission_ID,
    p.conditionSatisfactionDate AS Date_of_Satisfaction,
    T29.itemValue AS Condition_Name,
    (CASE
        WHEN
            T17.logoUrl IS NULL
                AND T21.orgUrl IS NOT NULL
        THEN
            CONCAT(T21.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T17.logoUrl IS NULL
                AND T21.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(T21.orgUrl, '/', T17.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T17.headerUrl IS NOT NULL
                AND T21.orgUrl IS NOT NULL
        THEN
            CONCAT(T21.orgUrl, '/', T17.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T17.footerUrl IS NOT NULL
                AND T21.orgUrl IS NOT NULL
        THEN
            CONCAT(T21.orgUrl, '/', T17.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
    (SELECT 
            GROUP_CONCAT(DISTINCT deviceTokenId)
        FROM
            fire_base_persons_info
        WHERE
            fire_base_persons_info.userId = T3.id) AS DEVICE_ID
FROM
    student_program_wise_condition_detail p
        LEFT JOIN
    app_program_adm_details pc ON pc.id = p.appProgramAdmDetailsId
        AND pc.isLatest = TRUE
        LEFT JOIN
    application_program ap ON ap.id = pc.applicationProgramId
        LEFT JOIN
    application a ON a.id = ap.applicationId
        LEFT JOIN
    persons T1 ON T1.id = p.personId
        LEFT JOIN
    students T2 ON T2.personId = T1.id
        LEFT JOIN
    users T3 ON T3.id = T2.userId
        LEFT JOIN
    admission T4 ON T4.studentId = T3.id
        AND T4.programId = ap.programId
        LEFT JOIN
    programs T5 ON T5.id = ap.programId
        LEFT JOIN
    batches T6 ON T6.id = T4.batchId
        LEFT JOIN
    department T7 ON T7.id = T5.programDepartmentId
        LEFT JOIN
    program_group T8 ON T8.id = T5.programGroupId
        LEFT JOIN
    salutations T10 ON T10.id = T1.salutationId
        LEFT JOIN
    gender T11 ON T11.id = T1.genderId
        LEFT JOIN
    academy_location T17 ON T17.id = T4.academyLocationId
        LEFT JOIN
    academy_location_addresses T12 ON T12.academyLocationId = T17.id
        LEFT JOIN
    address T13 ON T13.id = T12.addressId
        LEFT JOIN
    city T14 ON T14.id = T13.cityId
        LEFT JOIN
    country T15 ON T15.id = T14.countryId
        LEFT JOIN
    country_region T16 ON T16.id = T14.countryRegionId
        LEFT JOIN
    academies T18 ON T18.id = T17.academyId
        LEFT JOIN
    locations T19 ON T19.id = T17.locationId
        LEFT JOIN
    department T20 ON T20.id = T5.subDepartmentId
        LEFT JOIN
    organizations T21 ON T21.id = T18.organizationId
        LEFT JOIN
    organization_addresses T22 ON T22.organizationId = T21.id
        LEFT JOIN
    address T23 ON T23.id = T22.addressId
        LEFT JOIN
    city T24 ON T24.id = T23.cityId
        LEFT JOIN
    country T25 ON T25.id = T24.countryId
        LEFT JOIN
    country_region T26 ON T26.id = T24.countryRegionId
        LEFT JOIN
    program_batch_students T27 ON T27.admissionId = T4.id
        AND T27.isCurrentPeriod = TRUE
        AND T27.isCurrentSection = TRUE
        AND T27.isPeriodCompleted = FALSE
        AND T27.exitDate IS NULL
        LEFT JOIN
    prog_batch_period_config T28 ON T28.id = T27.progBatchPeriodConfigId
        LEFT JOIN
    admission_condition T29 ON T29.id = p.admissionConditionId
WHERE
    p.id in (namedParams)  AND T23.addressTypeId = (SELECT 
            id
        FROM
            address_type oat
        WHERE
            oat.code = 'REG'
                AND oat.addressCategory = 'ORG') AND  T13.addressTypeId = (SELECT 
            id
        FROM
            address_type atal
        WHERE
            atal.code = 'CRNT'
                AND atal.addressCategory = 'ACDLOC')",jsonString ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "orgName",
            "resultKey": "Organization_Name",
            "displayCode": "",
            "displayOrder": 1
        },
	 {
            "id": 3,
            "value": "countryName",
            "resultKey": "Organization_countryName",
            "displayCode": "",
            "displayOrder": 2
        },
	 {
            "id": 4,
            "value": "countryRegionName",
            "resultKey": "Organization_countryRegionName",
            "displayCode": "",
            "displayOrder": 3
        },
	 {
            "id": 5,
            "value": "cityName",
            "resultKey": "Organization_cityName",
            "displayCode": "",
            "displayOrder": 4
        },
	 {
            "id": 6,
            "value": "pincode",
            "resultKey": "Organization_pincode",
            "displayCode": "",
            "displayOrder": 5
        },
	 {
            "id": 7,
            "value": "postalCode",
            "resultKey": "Organization_postalCode",
            "displayCode": "",
            "displayOrder": 6
        },
	 {
            "id": 8,
            "value": "phoneNo",
            "resultKey": "Organization_phoneNo",
            "displayCode": "",
            "displayOrder": 7
        },
	 {
            "id": 9,
            "value": "cellNo",
            "resultKey": "Organization_cellNo",
            "displayCode": "",
            "displayOrder": 8
        },
	 {
            "id": 10,
            "value": "primaryeEmailId",
            "resultKey": "Organization_primaryeEmailId",
            "displayCode": "",
            "displayOrder": 9
        },
	 {
            "id": 11,
            "value": "locationName",
            "resultKey": "Academic_location",
            "displayCode": "",
            "displayOrder": 10
        },
	 {
            "id": 12,
            "value": "countryName",
            "resultKey": "Academiclocation_countryName",
            "displayCode": "",
            "displayOrder": 11
        },
	 {
            "id": 13,
            "value": "countryRegionName",
            "resultKey": "Academiclocation_countryRegionName",
            "displayCode": "",
            "displayOrder": 12
        },
	 {
            "id": 14,
            "value": "cityName",
            "resultKey": "Academiclocation_cityName",
            "displayCode": "",
            "displayOrder": 13
        },
	 {
            "id": 15,
            "value": "pincode",
            "resultKey": "Academiclocation_pincode",
            "displayCode": "",
            "displayOrder": 14
        },
	 {
            "id": 16,
            "value": "postalCode",
            "resultKey": "Academiclocation_postalCode",
            "displayCode": "",
            "displayOrder": 15
        },
	 {
            "id": 17,
            "value": "phoneNo",
            "resultKey": "Academiclocation_phoneNo",
            "displayCode": "",
            "displayOrder": 16
        },
	 {
            "id": 18,
            "value": "cellNo",
            "resultKey": "Academiclocation_cellNo",
            "displayCode": "",
            "displayOrder": 17
        },
	 {
            "id": 19,
            "value": "primaryeEmailId",
            "resultKey": "Academiclocation_primaryeEmailId",
            "displayCode": "",
            "displayOrder": 18
        },
	 {
            "id": 20,
            "value": "code",
            "resultKey": "Student_ID",
            "displayCode": "",
            "displayOrder": 19
        },
	{
            "id": 21,
            "value": "salutationName",
            "resultKey": "Salutation",
            "displayCode": "",
            "displayOrder": 20
        },
	 {
            "id": 22,
            "value": "code",
            "resultKey": "Application_ID",
            "displayCode": "",
            "displayOrder": 21
        },
	 {
            "id": 23,
            "value": "programCode",
            "resultKey": "Programme_Code",
            "displayCode": "",
            "displayOrder": 22
        },
	 {
            "id": 24,
            "value": "shortCode",
            "resultKey": "Department_Code",
            "displayCode": "",
            "displayOrder": 23
        },
	 {
            "id": 25,
            "value": "shortCode",
            "resultKey": "Subdepartment_Code",
            "displayCode": "",
            "displayOrder": 24
        },
        {
            "id": 26,
            "value": "printName",
            "resultKey": "Period_Name",
            "displayCode": "",
            "displayOrder": 25
        },
        {
            "id": 27,
            "value": "Current Date",
            "resultKey": "Curr_Date",
            "displayCode": "",
            "displayOrder": 26
        },
        {
            "id": 28,
            "value": "itemValue",
            "resultKey": "Student_Gender",
            "displayCode": "",
            "displayOrder": 27
        },
        {
            "id": 29,
            "value": "admissionDate",
            "resultKey": "Admission_date",
            "displayCode": "",
            "displayOrder": 28
        },
        {
            "id": 30,
            "value": "groupName",
            "resultKey": "Programme_Group",
            "displayCode": "",
            "displayOrder": 29
        },
        {
            "id": 31,
            "value": "nationalId",
            "resultKey": "Identity_No",
            "displayCode": "",
            "displayOrder": 30
        },
        {
            "id": 32,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 31
        },
        {
            "id": 33,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 32
        },
        {
            "id": 34,
            "value": "alternateEmailId",
            "resultKey": "ALTERNATE_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 33
        },
        {
            "id": 35,
            "value": "printName",
            "resultKey": "Student_Name",
            "displayCode": "",
            "displayOrder": 34
        },
        {
            "id": 36,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 35
        },
        {
            "id": 37,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 36
        },
        {
            "id": 38,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 37
        },
        {
            "id": 39,
            "value": "programNameToBePrint",
            "resultKey": "Programme_Name",
            "displayCode": "",
            "displayOrder": 38
        },
        {
            "id": 40,
            "value": "deptName",
            "resultKey": "Department_Name",
            "displayCode": "",
            "displayOrder": 39
        },
        {
            "id": 41,
            "value": "deptName",
            "resultKey": "Subdepartment_Name",
            "displayCode": "",
            "displayOrder": 40
        },
        {
            "id": 42,
            "value": "code",
            "resultKey": "Admission_ID",
            "displayCode": "",
            "displayOrder": 41
        },
        {
            "id": 43,
            "value": "conditionSatisfactionDate",
            "resultKey": "Date_of_Satisfaction",
            "displayCode": "",
            "displayOrder": 42
        },
        {
            "id": 44,
            "value": "itemValue",
            "resultKey": "Condition_Name",
            "displayCode": "",
            "displayOrder": 43
        },
        {
            "id": 45,
            "value": "logoURL",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 44
        },
        {
            "id": 46,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 45
        },
        {
            "id": 47,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 46
        }
    ]
}'
where dataProviderId = @dtproviderId; 
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240404125921__Update_OntheExpiryDateSatisfactionEvent () $$
DROP PROCEDURE IF EXISTS V20240404125921__Update_OntheExpiryDateSatisfactionEvent $$
DELIMITER ;