DELIMITER $$
DROP PROCEDURE IF EXISTS V20240417161559__Insert_OUMStatementOfAccount $$
CREATE PROCEDURE V20240417161559__Insert_OUMStatementOfAccount()
BEGIN

IF NOT EXISTS ((SELECT * FROM report_template WHERE templateCode = 'OUM_STATEMENT_OF_ACCOUNT')) THEN 
INSERT INTO report_template
(reportTypeId, templateCode, templateName, imageLocation, jasperFileLocation, documentTypes, whetherDefault, headerJasperFileLocation, footerJasperFileLocation, repeatHeaderOnAllPages, repeatFooterOnAllPages, bodyJasperFileLocation, defaultHeaderLogo)
VALUES ( '6', 'OUM_STATEMENT_OF_ACCOUNT', 'OUM Statement of Account', 'OUM_STATEMENT_OF_ACCOUNT.png','CommonReportOUM_SOA.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', "OUM_StatementofAccount.jasper", 'AcademiaLogo.png');
END IF;

set @OUM_STATEMENT_OF_ACCOUNT = (select max(id) from report_template where templateCode ='OUM_STATEMENT_OF_ACCOUNT');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT and keyValue='TRANS_SOA')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT, 'TRANS_SOA', 'Statement of Account', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT and keyValue='TRANS_NAME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT, 'TRANS_NAME', 'Name', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT and keyValue='TRANS_STUDENT_ID')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT, 'TRANS_STUDENT_ID', 'Student ID', '1', NOW());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT and keyValue='TRANS_APPLICANT_ID')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT, 'TRANS_APPLICANT_ID', 'Applicant ID', '1', NOW());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT and keyValue='TRANS_STATEMENT_DATE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT, 'TRANS_STATEMENT_DATE', 'Statement Date', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT and keyValue='TRANS_INTAKE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT, 'TRANS_INTAKE', 'Intake', '1', NOW());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT and keyValue='TRANS_PERIOD')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT, 'TRANS_PERIOD', 'Period', '1', NOW());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT and keyValue='TRANS_PROGRAM')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT, 'TRANS_PROGRAM', 'Programme Name', '1', NOW());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT and keyValue='TRANS_DATE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT, 'TRANS_DATE', 'Date', '1', NOW());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT and keyValue='TRANS_REFERENCE_NUMBER')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT, 'TRANS_REFERENCE_NUMBER', 'Reference Number', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT and keyValue='TRANS_DESCRIPTION')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT, 'TRANS_DESCRIPTION', 'Description', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT and keyValue='TRANS_DR')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT, 'TRANS_DR', 'Dr', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT and keyValue='TRANS_CR')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT, 'TRANS_CR', 'Cr', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT and keyValue='TRANS_BALANCE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT, 'TRANS_BALANCE', 'Balance', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@OUM_STATEMENT_OF_ACCOUNT and keyValue='TRANS_FOOTER')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@OUM_STATEMENT_OF_ACCOUNT, 'TRANS_FOOTER', 'This is a computer-generated document and requires no authentication. If you have any queries,contact us by email at feesfinance@open.ac.mu', '1', NOW());
END IF;

END $$
CALL V20240417161559__Insert_OUMStatementOfAccount() $$
DROP PROCEDURE IF EXISTS V20240417161559__Insert_OUMStatementOfAccount $$
DELIMITER ;