DELIMITER $$
DROP PROCEDURE IF EXISTS V20240508131241__Create_exam_sunshine_time_table $$
CREATE PROCEDURE V20240508131241__Create_exam_sunshine_time_table()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_course_resource_mapping')) THEN 
CREATE TABLE `exam_course_resource_mapping` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `courseId` BIGINT NOT NULL,
  `eventId` BIGINT NOT NULL,
  `resourceId` BIGINT NOT NULL,
  `status` BIT(1) NOT NULL DEFAULT b'0',
  `lastUpdatedBy` BIGINT NOT NULL DEFAULT 1,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `exam_course_resource_mapping_unique_key` (`courseId`,`eventId`,`resourceId`),
  INDEX `exam_course_resource_mapping_event_id_fk_idx` (`eventId` ASC) VISIBLE,
  INDEX `exam_course_resource_mapping_course_id_fk_idx` (`courseId` ASC) VISIBLE,
  INDEX `exam_course_resource_mapping_resource_id_fk_idx` (`resourceId` ASC) VISIBLE,
  INDEX `exam_course_resource_mapping_user_id_fk_idx` (`lastUpdatedBy` ASC) VISIBLE,
  CONSTRAINT `exam_course_resource_mapping_event_id_fk`
    FOREIGN KEY (`eventId`)
    REFERENCES `eval_seq_detail` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `exam_course_resource_mapping_course_id_fk`
    FOREIGN KEY (`courseId`)
    REFERENCES `courses` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `exam_course_resource_mapping_resource_id_fk`
    FOREIGN KEY (`resourceId`)
    REFERENCES `resources` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `exam_course_resource_mapping_user_id_fk`
  FOREIGN KEY (`lastUpdatedBy`)
  REFERENCES `users` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION)
ENGINE = InnoDB DEFAULT CHARACTER SET = utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_result_resource_mapping')) THEN 
CREATE TABLE `exam_result_resource_mapping` (
   `id` BIGINT NOT NULL AUTO_INCREMENT,
  `examinationResultId` bigint NOT NULL,
  `courseResourceMappingId` bigint NOT NULL,
  `concessionType` varchar(50) DEFAULT NULL,
  `publishStatus` BIT(1) NOT NULL DEFAULT b'0',
  `lastUpdatedBy` bigint NOT NULL DEFAULT '1',
   `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `exam_result_resource_mapping_examinationResultId_UNIQUE` (`examinationResultId`),
  KEY `exam_result_resource_mapping_exam_result_id` (`examinationResultId`),
  KEY `exam_result_resource_mapping_user_fk_idx` (`lastUpdatedBy`),
  KEY `exam_result_resource_mapping_resources_fk_idx` (`courseResourceMappingId`),
  CONSTRAINT `exam_result_resource_mapping_examination_result_fk` FOREIGN KEY (`examinationResultId`) REFERENCES `examination_result` (`id`),
  CONSTRAINT `exam_result_resource_mapping_resources_fk` FOREIGN KEY (`courseResourceMappingId`) REFERENCES `exam_course_resource_mapping` (`id`),
  CONSTRAINT `exam_result_resource_mapping_user_fk` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
END IF; 


IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_external_invigilator_master_data')) THEN 
CREATE TABLE `exam_external_invigilator_master_data` (
	 `id` BIGINT NOT NULL AUTO_INCREMENT,
	`position` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`gender` VARCHAR(45) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`firstName` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`lastName` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`nationality` VARCHAR(45) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`identificationNumber` VARCHAR(45) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`emailId` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`phoneNumber` VARCHAR(25) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`address` VARCHAR(512) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`race` VARCHAR(20) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`highestEducationQualification` VARCHAR(45) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`status` BIT(1) NOT NULL DEFAULT b'0',
    `lastUpdatedBy` bigint NOT NULL DEFAULT '1',
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`) USING BTREE,
   KEY `exam_external_invigilator_master_data_fk_idx` (`lastUpdatedBy`),
   CONSTRAINT `exam_external_invigilator_master_data_fk` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
)
COLLATE='utf8mb4_0900_ai_ci'
ENGINE=InnoDB
DEFAULT CHARSET=utf8mb4;
END IF; 



IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_course_resource_invigilator_mapping')) THEN 
CREATE TABLE `exam_course_resource_invigilator_mapping` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `seniorInvigilatorId` bigint DEFAULT NULL,
  `firstInvigilatorId` bigint DEFAULT NULL,
  `secondInvigilatorId` bigint DEFAULT NULL,
  `thirdInvigilatorId` bigint DEFAULT NULL,
  `courseResourceMappingId` bigint NOT NULL,
  `status` BIT(1) NOT NULL DEFAULT b'0',
  `lastUpdatedBy` bigint NOT NULL DEFAULT '1',
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `invigilator_mapping_seniorInvigilatorId_fk_idx` (`seniorInvigilatorId`),
  KEY `invigilator_mapping_firstInvigilatorId_fk_idx` (`firstInvigilatorId`),
  KEY `invigilator_mapping_secondInvigilatorId_fk_idx` (`secondInvigilatorId`),
  KEY `invigilator_mapping_thirdInvigilatorId_fk_idx` (`thirdInvigilatorId`),
  KEY `invigilator_mapping_course_resource-Id_idx` (`courseResourceMappingId`),
  KEY `invigilator_mapping_last_updated_by_id_idx` (`lastUpdatedBy`),
  CONSTRAINT `invigilator_mapping_seniorInvigilatorId_fk` FOREIGN KEY (`seniorInvigilatorId`) REFERENCES `exam_external_invigilator_master_data` (`id`),
  CONSTRAINT `invigilator_mapping_firstInvigilatorId_fk` FOREIGN KEY (`firstInvigilatorId`) REFERENCES `exam_external_invigilator_master_data` (`id`),
  CONSTRAINT `invigilator_mapping_secondInvigilatorId_fk` FOREIGN KEY (`secondInvigilatorId`) REFERENCES `exam_external_invigilator_master_data` (`id`),
  CONSTRAINT `invigilator_mapping_thirdInvigilatorId_fk` FOREIGN KEY (`thirdInvigilatorId`) REFERENCES `exam_external_invigilator_master_data` (`id`),
  CONSTRAINT `invigilator_mapping_course_resource-Id_fk` FOREIGN KEY (`courseResourceMappingId`) REFERENCES `exam_course_resource_mapping` (`id`),
  CONSTRAINT `invigilator_mapping_last_updated_by_id_fk` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
END IF; 

END $$
CALL V20240508131241__Create_exam_sunshine_time_table () $$ 
DROP PROCEDURE IF EXISTS V20240508131241__Create_exam_sunshine_time_table $$ 
DELIMITER ;