DELIMITER $$
DROP PROCEDURE IF EXISTS V20240514100948__Create_LearningAllowancesCSM $$
CREATE PROCEDURE V20240514100948__Create_LearningAllowancesCSM()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='learning_allowances_csm')) THEN 
CREATE TABLE `learning_allowances_csm` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`itemCode` VARCHAR(255) NOT NULL,
	`itemValue` VARCHAR(255) NOT NULL,
	`activeStatus` BIT(1) NOT NULL DEFAULT b'1',
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `fk_learning_allowances_csm_lastUpdatedBy_idx` (`lastUpdatedBy`),
	CONSTRAINT `fk_learning_allowances_csm_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

	-- ------------------CSM DATA-------------------------------------------------
SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'learning_allowances_csm')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'learning_allowances_csm','LEARNING_ALLOWANCES','Student Profile','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;

IF EXISTS ((SELECT * FROM standard_master WHERE tableName = 'learning_allowances_csm')) THEN 
SET @standardMasterId=(SELECT id FROM standard_master WHERE tableName = 'learning_allowances_csm');

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('code','ITEM_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('value','ITEM_VALUE',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

INSERT INTO standard_master_items (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('activeStatus','ACTIVE_STATUS',@standardMasterId,'Boolean',NULL,3,0,NULL,NULL,NULL,0,0,0,1,now());

END IF; 

-- ------------------TRANSLATION-------------------------------------------------

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' AND keyName = 'LEARNING_ALLOWANCES')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'LEARNING_ALLOWANCES', 'Learning Allowance', 'Learning Allowance','Leertoelae','Trợ cấp học tập',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' AND keyName = 'ACTIVE_STATUS')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'ACTIVE_STATUS', 'Active', 'Active','Aktief','Tích cực',now(),1);
END IF;

END $$
CALL V20240514100948__Create_LearningAllowancesCSM () $$ 
DROP PROCEDURE IF EXISTS V20240514100948__Create_LearningAllowancesCSM $$ 
DELIMITER ;