DELIMITER $$
DROP PROCEDURE IF EXISTS V20240516122041__Create_Send_Payment_Link_Student $$
CREATE PROCEDURE V20240516122041__Create_Send_Payment_Link_Student()
BEGIN

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='SEND_ONLINE_PAYMENT_LINK')) THEN
 SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='FEE_PAYMENT');
 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
 INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'SEND_ONLINE_PAYMENT_LINK');
 
 SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
 SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='SEND_ONLINE_PAYMENT_LINK');
 INSERT INTO `system_msg_event`
 (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
 VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'SEND_ONLINE_PAYMENT_LINK', 'Send Online Payment Link - Student', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Send Online Payment Link - Student');
 
 SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
 INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
 VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 -- Template data provider for the Event
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'SEND_ONLINE_PAYMENT_LINK_DL', 'SQL');
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'SEND_ONLINE_PAYMENT_LINK_RECIPIENT', 'SQL');
 
 -- Create Recipient Type
 
 SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SEND_ONLINE_PAYMENT_LINK_RECIPIENT');
 INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'SEND_ONLINE_PAYMENT_LINK_RECIPIENT');
 
 SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SEND_ONLINE_PAYMENT_LINK_DL');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='SEND_ONLINE_PAYMENT_LINK_RECIPIENT');
 INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
 VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);
 
 -- Setting the query for the Applicant distribution list
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SEND_ONLINE_PAYMENT_LINK_DL');
 INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT DISTINCT T1.id AS USER_ID FROM payment_link T1 WHERE T1.id IN (namedParams)",NULL);
 
 -- Setting the query for the User Recipient
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SEND_ONLINE_PAYMENT_LINK_RECIPIENT');
 INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
 "SELECT DISTINCT
    T1.id AS ID,
	T11.printName AS STUDENT_NAME,
    T11.firstName AS FIRST_NAME,
    T11.middleName AS MIDDLE_NAME,
	T11.lastName AS LAST_NAME,
	T1.totalOutstandingAmount AS AMOUNT,
    T1.encryptedlink AS PAYMENT_LINK,
    T10.currencyCode AS CURRENCY,
    T6.displayName AS CAMPUS_DISPLAY_NAME,
    T8.primaryeEmailId AS CAMPUS_CONTACT_EMAIL,
    T8.phoneNo AS CAMPUS_CONTACT_PHONE,
    T8.cellNo AS CAMPUS_CONTACT_NUMBER,
    T8.websiteURL AS CAMPUS_WEBSITE,
    T13.printName AS PARENT1,
    T15.printName AS PARENT2,
    T11.mobileNumber as MOBILE_NO,
    T11.emailId AS EMAIL_ID
FROM
    payment_link T1
		LEFT OUTER JOIN 
    students T2 ON T2.userId = T1.studentId 
		LEFT OUTER JOIN	
	payment_link_bills T3 ON T3.paymentLinkId = T1.id   
        LEFT OUTER JOIN
    bill_header T4 ON T4.id = T3.billHeaderId    
        LEFT OUTER JOIN 
    user_academy_locations T5 ON T5.userId = T2.userId
        LEFT OUTER JOIN 
	academy_location T6 ON T6.id = T5.academyLocationId
        LEFT OUTER JOIN 
	academy_location_addresses T7 ON T7.academyLocationId = T6.id
        LEFT OUTER JOIN 
	address T8 ON T8.id = T7.addressId
	    LEFT OUTER JOIN 
    address_type T9 ON T9.id = T8.addressTypeId
       LEFT OUTER JOIN 
	currency T10 ON T10.id = T4.currencyId
	   LEFT OUTER JOIN 
    persons T11 ON T11.id = T2.personId
       LEFT OUTER JOIN
	person_relationships T12 ON T12.personId = T11.id and T12.relationship='FATHER'
	   LEFT OUTER JOIN
    persons T13 ON T13.id = T12.relatedPersonId
	  LEFT OUTER JOIN
	person_relationships T14 ON T14.personId = T11.id and T14.relationship='MOTHER'
      LEFT OUTER JOIN 
    persons T15 ON T15.id = T14.relatedPersonId  
WHERE
     T9.code='CRNT' and T9.addressCategory='ACDLOC' and 
    T1.id IN (namedParams)",'{
     "id": 1,
     "searchResultViewColumns": [        
        {
            "id": 1,
            "value": "code",
            "resultKey": "PAYMENT_LINK",
            "displayCode": "",
            "displayOrder": 0
        },
         {
            "id": 2,
            "value": "printName",
            "resultKey": "PARENT1",
            "displayCode": "",
            "displayOrder": 1
        },
         {
            "id": 3,
            "value": "printName",
            "resultKey": "PARENT2",
            "displayCode": "",
            "displayOrder": 2
        },              
        {
            "id": 4,
            "value": "printName",
            "resultKey": "STUDENT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "displayName",
            "resultKey": "CAMPUS_DISPLAY_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "primaryeEmailId",
            "resultKey": "CAMPUS_CONTACT_EMAIL",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "phoneNo",
            "resultKey": "CAMPUS_CONTACT_PHONE",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "cellNo",
            "resultKey": "CAMPUS_CONTACT_NUMBER",
            "displayCode": "",
            "displayOrder": 7
        },{
            "id": 9,
            "value": "websiteURL",
            "resultKey": "CAMPUS_WEBSITE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "currencyCode",
            "resultKey": "CURRENCY",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "totalOutstandingAmount",
            "resultKey": "AMOUNT",
            "displayCode": "",
            "displayOrder": 10
        }
    ]
 }');
 
 SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
 SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='SEND_ONLINE_PAYMENT_LINK_DL');
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
 
 SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='SEND_ONLINE_PAYMENT_LINK');
 
 SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
 SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='SEND_ONLINE_PAYMENT_LINK');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='SEND_ONLINE_PAYMENT_LINK_RECIPIENT');
 SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');
 
 INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
 VALUES(@msgtemplateconfigId+1,'Send Online Payment Link - Student',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Send Online Payment Link - Student',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','','');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'2','','');
 
 --  INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 -- VALUES (@msgtemplateId+3,@msgtemplateconfigId+1,'4','','');
 
 -- INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 -- VALUES (@msgtemplateId+4,@msgtemplateconfigId+1,'6','','');

END IF;



IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='SEND_ONLINE_PAYMENT_LINK')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'SEND_ONLINE_PAYMENT_LINK', 'Send Online Payment Link - Student', 'Send Online Payment Link - Student', 'Stuur aanlynbetalingskakel - Student', 'Gửi Link Thanh Toán Trực Tuyến - Sinh Viên',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='SEND_ONLINE_PAYMENT_LINK_DL')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'SEND_ONLINE_PAYMENT_LINK_DL', 'Send Online Payment Link - Student DL', 'Send Online Payment Link - Student DL', 'Stuur aanlynbetalingskakel - Student DL', 'Gửi Link Thanh Toán Trực Tuyến - DL Sinh Viên',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='SEND_ONLINE_PAYMENT_LINK_RECIPIENT')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'SEND_ONLINE_PAYMENT_LINK_RECIPIENT', 'Send Online Payment Link - Student Recipient', 'Send Online Payment Link - Student Recipient', 'Stuur aanlynbetalingskakel - Studente-ontvanger', 'Gửi link thanh toán trực tuyến - Sinh viên nhận',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='SEND_ONLINE_PAYMENT_LINK')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('SEND_ONLINE_PAYMENT_LINK', 'Send Online Payment Link - Student');
END IF;
  
IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='SEND_ONLINE_PAYMENT_LINK_DL')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('SEND_ONLINE_PAYMENT_LINK_DL', 'Send Online Payment Link - Student DL');
END IF;
  
IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='SEND_ONLINE_PAYMENT_LINK_RECIPIENT')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('SEND_ONLINE_PAYMENT_LINK_RECIPIENT', 'Send Online Payment Link - Student Recipient');
END IF; 




IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PAYMENT_LINK')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PAYMENT_LINK', 'Payment Link', 'Payment Link', 'Betaling skakel', 'Liên kết thanh toán',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PARENT1')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PARENT1', 'Parent 1', 'Parent 1', 'Ouer 1', 'Phụ huynh 1',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PARENT2')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PARENT2', 'Parent 2', 'Parent 2', 'Ouer 2', 'Phụ huynh 2',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='STUDENT_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'STUDENT_NAME', 'Student Name', 'Student Name', 'Studente naam', 'Tên học sinh',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='CAMPUS_DISPLAY_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'CAMPUS_DISPLAY_NAME', 'Campus Display Name', 'Campus Display Name', 'Kampus vertoonnaam', 'Tên hiển thị của trường',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='CAMPUS_CONTACT_EMAIL')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'CAMPUS_CONTACT_EMAIL', 'Campus Contact Email', 'Campus Contact Email', 'Kampus Kontak E-pos', 'Email liên hệ của trường',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='CAMPUS_CONTACT_PHONE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'CAMPUS_CONTACT_PHONE', 'Campus Contact Phone', 'Campus Contact Phone', 'Kampus Kontak foon', 'Điện thoại liên lạc của trường',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='CAMPUS_CONTACT_NUMBER')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'CAMPUS_CONTACT_NUMBER', 'Campus Contact Number', 'Campus Contact Number', 'Kampus Kontaknommer', 'Số liên lạc của trường',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='CAMPUS_WEBSITE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'CAMPUS_WEBSITE', 'Campus Website', 'Campus Website', 'Kampus webwerf', 'Trang web của trường',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='CURRENCY')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'CURRENCY', 'Currency', 'Currency', 'Geldeenheid', 'Tiền tệ',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='AMOUNT')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'AMOUNT', 'Amount', 'Amount', 'Bedrag', 'Số lượng',now(),1);
END IF;



END $$
CALL V20240516122041__Create_Send_Payment_Link_Student () $$ 
DROP PROCEDURE IF EXISTS V20240516122041__Create_Send_Payment_Link_Student $$ 
DELIMITER ;