DELIMITER $$
DROP PROCEDURE IF EXISTS V20240527162301__Insert_PrincipleSignatureDataProvider $$
CREATE PROCEDURE V20240527162301__Insert_PrincipleSignatureDataProvider()
BEGIN

IF NOT EXISTS ((select * from dydt_data_line_item where dataSourceCode='OFFER_LETTER_PRINCIPLE_SIGNATURE')) THEN 
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
SET @dydtdataproviderId=(SELECT id FROM `dydt_data_provider` where providerName='OFFER_LETTER_INFO');

INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'OFFER_LETTER_PRINCIPLE_SIGNATURE', '1',null, '1', '1', 
"select fd.imageBase64 as PRINCIPAL_SIGNATURE
 from application_program ap
left join programs p on p.id=ap.programId 
left outer join program_group_details pgd on pgd.academyLocationId=ap.academyLocationId and pgd.programGroupId=p.programGroupId
left join staffs s on s.userId=pgd.principalId 
left join faculty_documents fd on fd.facultyId=s.userId 
left join document_types dy on dy.id=fd.documentTypeId"
,
    'PRM_APPLICATION_PROGRAM_ID', 'PRINCIPAL_SIGNATURE', 'where ap.id=PRM_APPLICATION_PROGRAM_ID and dy.itemCode="Signature"','0');


 INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
    VALUES ('PRINCIPAL_SIGNATURE', 'Principal Signature',@dydtdatalinitemId+1);
   
END IF; 

END $$
CALL V20240527162301__Insert_PrincipleSignatureDataProvider() $$
DROP PROCEDURE IF EXISTS V20240527162301__Insert_PrincipleSignatureDataProvider $$
DELIMITER ;