DELIMITER $$
DROP PROCEDURE IF EXISTS V20240530124133__Create_BulkAcademicTopicsUpload $$
CREATE PROCEDURE V20240530124133__Create_BulkAcademicTopicsUpload()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='bulk_academic_topics_upload')) THEN 
CREATE TABLE `bulk_academic_topics_upload` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academicSubTopicId` bigint(20) NOT NULL,
  `batchId` bigint(20) NOT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  `academicTermId` bigint(20) DEFAULT NULL,
  `uploadedOn` DATETIME NULL DEFAULT NULL,
  `uploadedBy` bigint(20) DEFAULT NULL,
  `uploadedZipFilePath` VARCHAR(255) NULL DEFAULT NULL,
  `logFilePath` VARCHAR(255) NULL DEFAULT NULL,
  `publishOnStudentPortal` Boolean default false,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_bulk_academic_topics_upload_lastUpdatedBy_idx` (`lastUpdatedBy`),
  KEY `fk_bulk_academic_topics_upload_academicSubTopicId_idx` (`academicSubTopicId`),
  KEY `fk_bulk_academic_topics_upload_batchId_idx` (`batchId`),
  KEY `fk_bulk_academic_topics_upload_periodId_idx` (`periodId`),
  KEY `fk_bulk_academic_topics_upload_academicTermId_idx` (`academicTermId`),
  KEY `fk_bulk_academic_topics_upload_uploadedBy_idx` (`uploadedBy`),
  
  CONSTRAINT `fk_bulk_academic_topics_upload_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_bulk_academic_topics_upload_academicSubTopicId_idx` FOREIGN KEY (`academicSubTopicId`) REFERENCES `academic_sub_topics` (`id`),
  CONSTRAINT `fk_bulk_academic_topics_upload_batchId` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`),
  CONSTRAINT `fk_bulk_academic_topics_upload_periodId` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`),
  CONSTRAINT `fk_bulk_academic_topics_upload_academicTermId` FOREIGN KEY (`academicTermId`) REFERENCES `academic_term` (`id`),
  CONSTRAINT `fk_bulk_academic_topics_upload_uploadedBy_idx` FOREIGN KEY (`uploadedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB;
END IF; 

END $$
CALL V20240530124133__Create_BulkAcademicTopicsUpload () $$ 
DROP PROCEDURE IF EXISTS V20240530124133__Create_BulkAcademicTopicsUpload $$ 
DELIMITER ;