DELIMITER $$
DROP PROCEDURE IF EXISTS V20240611122019__Create_canvasUserMapping $$
CREATE PROCEDURE V20240611122019__Create_canvasUserMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='canvas_user_mapping')) THEN 
CREATE TABLE canvas_user_mapping (
    id bigint NOT NULL AUTO_INCREMENT,
    canvasUserId bigint,
    academiaUserId bigint NOT NULL,
	academyLocationId bigint NOT NULL,
    isActive BIT(1) NOT NULL DEFAULT b'1',
    remark VARCHAR(255),
    lastUpdatedBy bigint NOT NULL,
    lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_canvas_user_mapping_lastUpdatedBy_idx (lastUpdatedBy),
  KEY fk_canvas_user_mapping_academiaUserId_idx (academiaUserId),
  KEY fk_canvas_user_mapping_academyLocationId_idx (academyLocationId),
  CONSTRAINT fk_canvas_user_mapping_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id),
  CONSTRAINT fk_canvas_user_mapping_academiaUserId FOREIGN KEY (academiaUserId) REFERENCES users (id),
  CONSTRAINT fk_canvas_user_mapping_academyLocationId FOREIGN KEY (academyLocationId) REFERENCES academy_location (id)
) ENGINE=InnoDB;
END IF; 

END $$
CALL V20240611122019__Create_canvasUserMapping () $$ 
DROP PROCEDURE IF EXISTS V20240611122019__Create_canvasUserMapping $$ 
DELIMITER ;