DELIMITER $$
DROP PROCEDURE IF EXISTS V20240618182214__Create_studentTrnsMulResoan $$
CREATE PROCEDURE V20240618182214__Create_studentTrnsMulResoan()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_transfer_request_multiple_reason')) THEN 
 CREATE TABLE `student_transfer_request_multiple_reason` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `studentTransferRequestDetailId` BIGINT(20) NOT NULL,
  `studentTransferReasonId` BIGINT(20) NULL,
  `reasonRemark` longtext NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_student_transfer_multiple_reason_request_detail_idx` (`studentTransferRequestDetailId` ASC),
  INDEX `fk_student_transfer_request_multiple_reason_pw_reason_idx` (`studentTransferReasonId` ASC),
  INDEX `fk_student_transfer_request_multiple_reason_users_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_student_transfer_multiple_reason_transferRequestDetail_id`
    FOREIGN KEY (`studentTransferRequestDetailId`)
    REFERENCES `student_transfer_request_details` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	CONSTRAINT `fk_student_transfer_request_multiple_reason_pw_reason_id`
    FOREIGN KEY (`studentTransferReasonId`)
    REFERENCES `drop_down` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_student_transfer_request_multiple_reasons_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF;  

END $$
CALL V20240618182214__Create_studentTrnsMulResoan () $$ 
DROP PROCEDURE IF EXISTS V20240618182214__Create_studentTrnsMulResoan $$ 
DELIMITER ;