DELIMITER $$
DROP PROCEDURE IF EXISTS getProgBatchPeriodCourseForMoodle $$
CREATE PROCEDURE getProgBatchPeriodCourseForMoodle(IN academyLocationId INTEGER, IN lastUpdate DATETIME)
BEGIN
    SELECT 
        p.academyLocationId AS academy_location_id,
        p.id AS prog_id,
        p.programCode AS prog_code,
        p.programName AS prog_name,
        p.lastUpdate AS prog_lastupdate,
        mprog.moodleId AS prog_moodleid,
        mprog.parentMoodleId AS prog_parent_moodleid,
        mprog.moodlePath as prog_moodle_path,
        b.id AS batch_id,
        b.batchName AS batch_name,
        b.lastUpdate AS batch_lastupdate,
        mb.moodleId AS batch_moodleid,
        mprog.moodleId AS batch_parent_moodleid,
        mb.moodlePath as batch_moodle_path,
        period.id AS period_id,
        period.programPeriodName AS period_name,
        period.lastUpdate AS period_lastupdate,
        mperiod.moodleId AS period_moodleid,
        mb.moodleId AS period_parent_moodleid,
        mperiod.moodlePath as period_moodle_path,
        c.id AS course_id,
        c.courseCode AS course_code,
        c.courseName AS course_name,
        c.lastUpdate AS course_lastupdate,
        mc.moodleId AS course_moodleid,
        mperiod.moodleId AS course_parent_moodleid,
        mc.moodlePath as course_moodle_path,
        cv.id AS course_variant_id,
        param.sectionId AS section_id,
        cv.courseVariantCode AS course_variant_name,
        cv.lastUpdate AS course_variant_lastupdate,
        mcv.moodleCourseId AS course_variant_moodleid,
        mc.moodleId AS course_variant_parent_moodleid,
        mcv.moodlePath as course_var_moodle_path
    FROM
        program_batch_course_param param
        JOIN batches b ON param.programBatchId = b.id
        JOIN prog_batch_period_config period ON param.progBatchPeriodConfigId = period.id AND period.programBatchId = b.id
        JOIN programs p ON b.programId = p.id
        JOIN courses c ON param.courseId = c.id
        JOIN course_variants cv ON param.courseVarientId = cv.id
            AND param.courseId = c.id
            AND p.academyLocationId = cv.academyLocationId
        LEFT JOIN moodle_transaction_info mprog ON mprog.academiaId = p.id
            AND mprog.moodleTransactionType = 'PROGRAM'
            AND mprog.hierarchy = 'PROG_BATCH_PERIOD_COURSE_VARIANT'
         and mprog.moodlePath = IF(mprog.moodleId=null, null, concat('/',mprog.moodleId))
        LEFT JOIN moodle_transaction_info mb ON mb.academiaId = b.id
            AND mb.parentAcademiaId = p.id
            AND mprog.hierarchy = mb.hierarchy
            AND mb.moodleTransactionType = 'BATCH'
            and mb.moodlePath = IF(mb.moodleId=null, null, concat(mprog.moodlePath, '/',mb.moodleId))
        LEFT JOIN moodle_transaction_info mperiod ON mperiod.academiaId = period.id
            AND mperiod.parentAcademiaId = b.id
            AND mb.hierarchy = mperiod.hierarchy
            AND mperiod.moodleTransactionType = 'PERIOD'
             and mperiod.moodlePath = IF(mperiod.moodleId=null, null, concat(mb.moodlePath, '/',mperiod.moodleId))
        LEFT JOIN moodle_transaction_info mc ON mc.academiaId = c.id
            AND mc.parentAcademiaId = period.id
            AND mperiod.hierarchy = mc.hierarchy
            AND mc.moodleTransactionType = 'COURSE'
			and mc.moodlePath = IF(mc.moodleId=null, null, concat(mperiod.moodlePath, '/',mc.moodleId))
        LEFT JOIN moodle_course mcv ON mcv.academiaCourseVariantId = cv.id
            AND mcv.sectionid = param.sectionId
            AND mcv.parentAcademiaId = c.id
            AND mcv.academyLocationId = p.academyLocationId
            AND mc.hierarchy = mcv.hierarchy
            and mcv.moodlePath = IF(mcv.moodleCourseId=null, null, concat(mc.moodlePath, '/',mcv.moodleCourseId))
            where p.academyLocationId = academyLocationId 
            and ( p.lastUpdate >=lastUpdate or  c.lastUpdate >=lastUpdate or  cv.lastUpdate >=lastUpdate );
END$$
DELIMITER ;