DELIMITER $$
DROP PROCEDURE IF EXISTS V20240718123957__Insert_OUM_PG_Transcript $$
CREATE PROCEDURE V20240718123957__Insert_OUM_PG_Transcript()
BEGIN

set  @OumPGTrans = (select max(id) from report_type where typeName='Mark Sheet');
IF NOT EXISTS (SELECT * FROM `report_template` WHERE templateCode = 'OUM_PG_TRANSCRIPT_TEMPLATE') THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`,`templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@OumPGTrans, 'OUM_PG_TRANSCRIPT_TEMPLATE', 'OUM Postgraduate Transcript Template', 'OUM_PG_TRANSCRIPT_TEMPLATE.png', 'OUM_PG_TRANSCRIPT_TEMPLATE_CommonReport.jasper', 'EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'OUM_PG_TRANSCRIPT_TEMPLATE.jasper', 'AcademiaLogo.png');
END IF;

IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'OUM_PG_TRANSCRIPT_TEMPLATE')) THEN 
set @H1 = (select max(id)  from report_template where templateCode ='OUM_PG_TRANSCRIPT_TEMPLATE');


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_FINAL_AWARD_TRANSCRIPT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_FINAL_AWARD_TRANSCRIPT', 'Final Award Transcript', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_NAME', 'Name:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_STD_ID')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_STD_ID', 'Student ID:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_INTAKE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_INTAKE', 'Intake:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_PROGRAM_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_PROGRAM_NAME', 'Programme Name:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_PROGRAM_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_PROGRAM_CODE', 'Programme Code:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_COURSE_LEVEL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_COURSE_LEVEL', 'Course Level:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_RESULTS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_RESULTS', 'Results:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SEMESTER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SEMESTER', 'Semester', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_MODULE_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_MODULE_NAME', 'Module Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_MODULE_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_MODULE_CODE', 'Module Code', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_MARKS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_MARKS', 'Marks\n(100%)', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_CREDITS_TAKEN')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_CREDITS_TAKEN', 'Credits Taken', '1', now());		
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_CREDITS_EARNED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_CREDITS_EARNED', 'Credits Earned', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_GRADE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_GRADE', 'Grade', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_OVERALL_PERFORMANCE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_OVERALL_PERFORMANCE', 'Overall Performance', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SEMESTER1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SEMESTER1', 'Semester', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_GPA')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_GPA', 'GPA', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SPA')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SPA', 'SPA', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_CT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_CT', 'Credits Taken', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_CE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_CE', 'Credits Earned', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_TCE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_TCE', 'Total Credits Earned', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_CPA')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_CPA', 'CPA:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_AWARD_CLASSIFICATION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_AWARD_CLASSIFICATION', 'Award Classification', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_DESCLAIMER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_DESCLAIMER', 'This is a computer-generated document and requires no authentication.', '1', now());
END IF;

END IF;  


END $$
CALL V20240718123957__Insert_OUM_PG_Transcript() $$
DROP PROCEDURE IF EXISTS V20240718123957__Insert_OUM_PG_Transcript $$
DELIMITER ;