DELIMITER $$
DROP PROCEDURE IF EXISTS getEvaluationLevelTwoAvg $$
CREATE PROCEDURE getEvaluationLevelTwoAvg(
    IN evaluationPlanLevelTwoId INT,
    IN courseVariantId INT
)
BEGIN
  SELECT
    CASE
        WHEN leveltwo.marksOrGrade = 'MARK' THEN
            (SELECT
                ROUND(AVG(tworank.effectiveMarks)) AS avgMarksGrade
             FROM
                evaluation_plan_level_two_rank AS tworank
             WHERE
                tworank.evaluationPlanLevelTwoId = leveltwo.id
                AND tworank.courseVariantId = courseVariantId)
        WHEN leveltwo.marksOrGrade = 'GRADE' THEN
            (SELECT
                g.gradeName as avgMarksGrade
             FROM
                grade AS g
             JOIN
                (SELECT
                    ROUND(AVG(tworank.gradePoint)) AS average_gradePoint,
                    leveltwo.gradeType
                 FROM
                    evaluation_plan_level_two_rank AS tworank
                 JOIN
                    evaluation_plan_level_two AS levelTwo ON levelTwo.id = tworank.evaluationPlanLevelTwoId
                 WHERE
                    tworank.evaluationPlanLevelTwoId = leveltwo.id
                    AND tworank.courseVariantId = courseVariantId
                 GROUP BY
                    levelTwo.gradeType) AS avgGrades
             ON
                g.gradeType = avgGrades.gradeType
                AND g.gradePoint = avgGrades.average_gradePoint)
        ELSE
            NULL
    END AS result
FROM
    evaluation_plan_level_two AS leveltwo
WHERE
    leveltwo.id = evaluationPlanLeveltwoId;
END$$

DELIMITER ;
