DELIMITER $$
DROP PROCEDURE IF EXISTS V20240812173023__Update_Student_Reset_Password_Recipient $$
CREATE PROCEDURE V20240812173023__Update_Student_Reset_Password_Recipient()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='STUDENT_RESET_PASSWORD_RECIPIENT')) THEN 
SET @residenceRCPNT=(select id from dtprovider d WHERE d.dataProviderName='STUDENT_RESET_PASSWORD_RECIPIENT' limit 1);
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = 'SELECT 
        T1.id AS ID,
        T3.`salutationName` AS SALUTATION_NAME,
        T1.`firstName` AS FIRST_NAME,
        T1.`middleName` AS MIDDLE_NAME,
        T1.`lastName` AS LAST_NAME,
        T2.`emailId` AS EMAIL_ID,
        T2.`mobileNumber` AS MOBILE_NO,
        T2.`mobileCountryCode` AS MOBILE_CODE,
        T2.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
        ml.code AS LANGUAGE_KEY,
        GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
        T1.resetPassword AS PDF_PASSWORD,
        T6.displayName AS ACADEMY_NAME_LOCATION,
        T6.academyName AS ACADEMY_NAME,
        T8.primaryeEmailId AS ACADEMY_EMAIL,
        T8.websiteURL AS WEBSITE_URL,
         concat(T8.phoneCountryCode,\'-\',T8.phoneAreaCode,\'-\',T8.phoneNo) AS PHONE_NUMBER,
        (CASE
            WHEN
                T6.logoUrl IS NULL
                    AND org.orgUrl IS NOT NULL
            THEN
                CONCAT(org.orgUrl,
                        \'/\',
                        \'emailer/images/logo_default_image.png\')
            WHEN
                T6.logoUrl IS NULL
                    AND org.orgUrl IS NULL
            THEN
                \'https://www.serosoft.com/mailer/academiaerp_logo_red.png\'
            ELSE CONCAT(org.orgUrl, \'/\', T6.logoUrl)
        END) AS LOGO_URL,
        (CASE
            WHEN
                T6.headerUrl IS NOT NULL
                    AND org.orgUrl IS NOT NULL
            THEN
                CONCAT(org.orgUrl, \'/\', T6.headerUrl)
            ELSE NULL
        END) AS HEADER_URL,
        (CASE
            WHEN
                T6.footerUrl IS NOT NULL
                    AND org.orgUrl IS NOT NULL
            THEN
                CONCAT(org.orgUrl, \'/\', T6.footerUrl)
            ELSE NULL
        END) AS FOOTER_URL
    FROM
        `users` T1
            INNER JOIN
        `students` T4 ON T4.`userId` = T1.`id`
            LEFT JOIN
        `persons` T2 ON T2.`id` = T4.`personId`
            LEFT JOIN
        `salutations` T3 ON T3.`id` = T2.`salutationId`
            LEFT JOIN
        `fire_base_persons_info` f ON f.userId = T1.id
            LEFT JOIN
        multi_language ml ON ml.id = T2.correspondence_language
            LEFT JOIN
        admission T5 ON T5.studentId = T1.id
            LEFT JOIN
        academy_location T6 ON T6.id = T5.academyLocationId
            LEFT JOIN
        academy_location_addresses T7 ON T7.academyLocationId = T6.id
            LEFT JOIN
        address T8 ON T8.id = T7.addressId AND T8.addressTypeId = 10 
            LEFT JOIN
        organizations org ON org.id = 1
    WHERE
         T4.userId IN (namedParams) order by T5.admissionDate desc limit 1'
WHERE
    dataProviderId=@residenceRCPNT;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240812173023__Update_Student_Reset_Password_Recipient () $$
DROP PROCEDURE IF EXISTS V20240812173023__Update_Student_Reset_Password_Recipient $$
DELIMITER ;