DELIMITER $$
DROP PROCEDURE IF EXISTS V20240812224440__Insert_StudentTransferDFR $$
CREATE PROCEDURE V20240812224440__Insert_StudentTransferDFR()
BEGIN

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'STD_TRANSFER_STATEMENT')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'STD_TRANSFER_STATEMENT', 'In order to process your Student transfer request, please ensure personal details, contact details, Passport details and Parent and Sponsor details are up to date.', 'In order to process your Student transfer request, please ensure personal details, contact details, Passport details and Parent and Sponsor details are up to date.','Om jou Student-oordragversoek te verwerk, maak asseblief seker dat persoonlike besonderhede, kontakbesonderhede, paspoortbesonderhede en ouer- en borgbesonderhede op datum is.','Để xử lý yêu cầu chuyển trường Sinh viên của bạn, vui lòng đảm bảo thông tin cá nhân, chi tiết liên hệ, chi tiết Hộ chiếu và chi tiết Phụ huynh và Nhà tài trợ được cập nhật.',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'studenttransferrequestdetailspanel' and  `formFieldId`='stdTransferStatementId')) THEN
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('studenttransferrequestdetailspanel','stdTransferStatement','stdTransferStatementId','displayfield',0,0,NULL,1,now(),'In order to process your Student transfer request, please ensure personal details, contact details, Passport details and Parent and Sponsor details are up to date.','','Student Transfer','Create','In order to process your Student transfer request, please ensure personal details, contact details, Passport details and Parent and Sponsor details are up to date.',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'studenttransferrequestdetailspanel' and  `formFieldId`='visaRefusalCheck')) THEN
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('studenttransferrequestdetailspanel','visaRefusalCheck','visaRefusalCheck','checkbox',0,0,NULL,1,now(),'Please tick if you had a visa refusal in any country','','Student Transfer','Create','Please tick if you had a visa refusal in any country',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'studenttransferrequestdetailspanel' and  `formFieldId`='studiedInUkCheck')) THEN
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('studenttransferrequestdetailspanel','studiedInUkCheck','studiedInUkCheck','checkbox',0,0,NULL,1,now(),'Please tick if you have ever studied in the UK','','Student Transfer','Create','Please tick if you have ever studied in the UK',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'studenttransferrequestdetailspanel' and  `formFieldId`='healthInsuranceCheckId')) THEN
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('studenttransferrequestdetailspanel','healthInsuranceCheck','healthInsuranceCheckId','checkbox',0,0,NULL,1,now(),'Please tick here if you require to register for the School Health Insurance','','Student Transfer','Create','Please tick here if you require to register for the School Health Insurance',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'studenttransferrequestdetailspanel' and  `formFieldId`='scholarshipCheckId')) THEN
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('studenttransferrequestdetailspanel','scholarshipCheck','scholarshipCheckId','checkbox',0,0,NULL,1,now(),'Please tick here if you benefit from a Scholarship','','Student Transfer','Create','Please tick here if you benefit from a Scholarship',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'studenttransferrequestdetailspanel' and  `formFieldId`='medicalIssuesCheckId')) THEN
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('studenttransferrequestdetailspanel','medicalIssuesCheck','medicalIssuesCheckId','checkbox',0,0,NULL,1,now(),'Please tick here if you suffer from any medical issues or learning differences','','Student Transfer','Create','Please tick here if you suffer from any medical issues or learning differences',0);
END IF;

END $$
CALL V20240812224440__Insert_StudentTransferDFR() $$
DROP PROCEDURE IF EXISTS V20240812224440__Insert_StudentTransferDFR $$
DELIMITER ;