DELIMITER $$
DROP PROCEDURE IF EXISTS V20240821132100__Create_BYPassPromotion $$
CREATE PROCEDURE V20240821132100__Create_BYPassPromotion()
BEGIN
	
SET SQL_SAFE_UPDATES=0;
SET FOREIGN_KEY_CHECKS=0;
IF  EXISTS ((select * from standard_master_items where standardMasterId=(select id from standard_master where masterName='BY_PASS_PROMOTION_ELIGIBILITY_RULES')))THEN
delete from standard_master_items where standardMasterId=(select id from standard_master where masterName="BY_PASS_PROMOTION_ELIGIBILITY_RULES");
END IF;

IF  EXISTS ((select * from standard_master where masterName='BY_PASS_PROMOTION_ELIGIBILITY_RULES'))THEN
delete from standard_master where masterName='BY_PASS_PROMOTION_ELIGIBILITY_RULES';
END IF;

IF  EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='Promotion_Eligibility_Rule'))THEN
drop table Promotion_Eligibility_Rule;	
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='Promotion_Eligibility_Rule')) THEN 
CREATE TABLE `Promotion_Eligibility_Rule` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `promotionEligibilityRules`  VARCHAR(255) NOT NULL,
   `status`  VARCHAR(10) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_Promotion_Eligibility_Rule_updateby` (`lastUpdatedBy`),
  CONSTRAINT `fk_Promotion_Eligibility_Rule_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'Promotion_Eligibility_Rule','BYPASS_PROGRESSION_ELIGIBILITY_RULES','General','COMMON_MASTER',0,0,NULL,1,SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'promotionEligibilityRules', 'PROMOTION_ELIGIBILITY_RULES', @standardMasterMaxId+1, 'varchar', '1', 0, 0, 0, 0, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`,`emunType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`,maxLength, `lastUpdatedBy`, `lastUpdate`)
 VALUES (@ItemsMaxId + 1, 'status', 'Status', @standardMasterMaxId + 1, 'Enum','STATUS', '2', 0, 0, 0, 1,8, '1', NOW());

insert into picklist_enum(enumType, code, enumValue)
values('STATUS','TRUE','True' ),
('STATUS','FALSE','False');

insert into Promotion_Eligibility_Rule (`promotionEligibilityRules`, `status`,`lastUpdate`,`lastUpdatedBy`) values('Bypass Promotion Rules','False',SYSDATE(),1);
insert into Promotion_Eligibility_Rule (`promotionEligibilityRules`, `status`,`lastUpdate`,`lastUpdatedBy`) values('Bypass Passout Rules','False',SYSDATE(),1);
END IF; 

SET SQL_SAFE_UPDATES=1;
SET FOREIGN_KEY_CHECKS=1;
END $$
CALL V20240821132100__Create_BYPassPromotion () $$ 
DROP PROCEDURE IF EXISTS V20240821132100__Create_BYPassPromotion $$ 
DELIMITER ;