DELIMITER $$
DROP PROCEDURE IF EXISTS V20240903144153__Create_GraduationCeremonyMappedStd $$
CREATE PROCEDURE V20240903144153__Create_GraduationCeremonyMappedStd()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='graduation_ceremony_mapped_students')) THEN 
CREATE TABLE `graduation_ceremony_mapped_students` (
    `id` BIGINT NOT NULL AUTO_INCREMENT,
    `ceremonyId` BIGINT NOT NULL,
    `admissionId` BIGINT NOT NULL,
    `programBatchPeriodConfigId` BIGINT NOT NULL,
    `lastUpdatedBy` BIGINT NOT NULL,
    `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`), 
    CONSTRAINT `graduation_ceremony_mapped_students_ceremonyId_FK` FOREIGN KEY (`ceremonyId`) REFERENCES `ceremony`(`id`),
	CONSTRAINT `graduation_ceremony_mapped_students_admissionId_FK` FOREIGN KEY (`admissionId`) REFERENCES `admission`(`id`),
	CONSTRAINT `graduation_ceremony_mapped_students_periodId_FK` FOREIGN KEY (`programBatchPeriodConfigId`) REFERENCES `prog_batch_period_config`(`id`),
	CONSTRAINT `graduation_ceremony_mapped_students_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
);
END IF; 

END $$
CALL V20240903144153__Create_GraduationCeremonyMappedStd () $$ 
DROP PROCEDURE IF EXISTS V20240903144153__Create_GraduationCeremonyMappedStd $$ 
DELIMITER ;