DELIMITER $$
DROP PROCEDURE IF EXISTS V20240904155827__Insert_StudentNewFieldIDFR $$
CREATE PROCEDURE V20240904155827__Insert_StudentNewFieldIDFR()
BEGIN

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'personalinformationform' and formFieldId = 'academicBankCredits')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('personalinformationform', 'academicBankCredits', 'academicBankCredits', 'textfield', 0, 0, Null, 1, Now(), 'Academic Bank Of Credits (ABC)', '1', 'Personal Details Info', 'Create, Edit, and View', 'Academic Bank Of Credits (ABC)', 0);
END IF; 

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'personalinformationform' and formFieldId = 'coaStudent')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('personalinformationform', 'coaStudent', 'coaStudent', 'textfield', 0, 0, Null, 1, Now(), 'COA', '1', 'Personal Details Info', 'Create, Edit, and View', 'COA', 0);
END IF; 

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'personalinformationform' and formFieldId = 'naadStudent')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('personalinformationform', 'naadStudent', 'naadStudent', 'textfield', 0, 0, Null, 1, Now(), 'NAAD', '1', 'Personal Details Info', 'Create, Edit, and View', 'NAAD', 0);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='ACADEMIC_BANK_OF_CREDITS_ABC')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','ACADEMIC_BANK_OF_CREDITS_ABC','Academic Bank Of Credits (ABC)','Academic Bank Of Credits (ABC)','Akademiese Kredietbank (ABC)','Ngân hàng Tín dụng Học thuật (ABC)',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='COA')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','COA','COA','COA','COA','COA',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='NAAD')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','NAAD','NAAD','NAAD','NAAT','ĐƯỜNG MAY',now(),1);
END IF; 

END $$
CALL V20240904155827__Insert_StudentNewFieldIDFR() $$
DROP PROCEDURE IF EXISTS V20240904155827__Insert_StudentNewFieldIDFR $$
DELIMITER ;