DELIMITER $$
DROP PROCEDURE IF EXISTS V20240909140535__Create_PromotionStatusUpdateEvent $$
CREATE PROCEDURE V20240909140535__Create_PromotionStatusUpdateEvent()
BEGIN

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='PROMOTION_STATUS_UPDATE')) THEN
 SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='PROGRAM_AND_COURSE');
 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
 INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'PROMOTION_STATUS_UPDATE');
 
 SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
 SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='PROMOTION_STATUS_UPDATE');
 INSERT INTO `system_msg_event`
 (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
 VALUES (@systemmsgeventId+1, '2', @msgSubCategoryId, 'PROMOTION_STATUS_UPDATE', 'Promotion Status Update', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Promotion Status Update');
 
 SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
 INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
 VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 -- Template data provider for the Event
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'PROMOTION_STATUS_UPDATE_DL', 'SQL');
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'PROMOTION_STATUS_UPDATE_RECIPIENT', 'SQL');
 
 -- Create Recipient Type
 
 SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PROMOTION_STATUS_UPDATE_RECIPIENT');
 INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'PROMOTION_STATUS_UPDATE_RECIPIENT');
 
 SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PROMOTION_STATUS_UPDATE_DL');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='PROMOTION_STATUS_UPDATE_RECIPIENT');
 INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
 VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);
 
 -- Setting the query for the Applicant distribution list
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PROMOTION_STATUS_UPDATE_DL');
 INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT DISTINCT
    T1.id AS USER_ID
FROM
    program_batch_students T1
WHERE T1.isCurrentPeriod=true AND T1.isCurrentSection=true AND T1.exitDate is null
AND T1.id in(namedParams)",NULL);
 
 -- Setting the query for the User Recipient
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PROMOTION_STATUS_UPDATE_RECIPIENT');
 INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
 "SELECT DISTINCT
    T1.id AS ID,
    T9.code AS PROMOTION_STUDENT_ID,
    T10.firstName AS FIRST_NAME,
	T10.middleName AS MIDDLE_NAME,
	T10.lastName AS LAST_NAME,
	T10.printName AS PRINT_NAME,
	T10.emailId AS EMAIL_ID,
    T10.firstName AS PROMOTION_STUDENT_FIRST_NAME,
    T10.middleName AS PROMOTION_STUDENT_MIDDLE_NAME,
    T10.lastName AS PROMOTION_STUDENT_LAST_NAME,
	T10.printName AS PROMOTION_STUDENT_PRINT_NAME,
	T10.externalSysRefOne AS PROMOTION_EXTERNAL_REFERENCE_NUMBER_ONE,
	T11.salutationName AS PROMOTION_TITLE,
	T10.initials AS PROMOTION_INITIAL,
	T8.itemValue AS PROMOTION_ACADEMIC_TERM,
	T5.programNameToBePrint AS PROMOTION_PROGRAM,
	T4.printName AS PROMOTION_BATCH,
	T6.printName AS PROMOTION_PERIOD,
	T7.displayName AS PROMOTION_ACADEMY_LOCATION,
	T13.itemValue AS PROMOTION_STATUS,
    ml.code as LANGUAGE_KEY,
	(SELECT 
            GROUP_CONCAT(DISTINCT deviceTokenId)
        FROM
            fire_base_persons_info
        WHERE
            fire_base_persons_info.userId = T5.id) AS DEVICE_ID,
	T10.mobileCountryCode as MOBILE_CODE,
    T10.mobileNumber as MOBILE_NO
FROM
    program_batch_students T1	
        LEFT OUTER JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT OUTER JOIN
    students T3 ON T2.studentId = T3.userId
        LEFT OUTER JOIN
    batches T4 ON T1.programBatchId = T4.id
        LEFT OUTER JOIN
    programs T5 ON T4.programId = T5.id
        LEFT OUTER JOIN
    prog_batch_period_config T6 ON T1.progBatchPeriodConfigId = T6.id
        LEFT OUTER JOIN
	academy_location T7 on T7.id = T5.academyLocationId
		LEFT OUTER JOIN
	academic_term T8 on T8.id = T6.academicTermId
		LEFT OUTER JOIN
	users T9 on T9.id = T3.userId
		LEFT OUTER JOIN
	persons T10 on T10.id = T3.personId
		LEFT OUTER JOIN
	salutations T11 on T11.id = T10.salutationId
		LEFT OUTER JOIN
	promotion T12 on T12.fromRecordId=T1.id
                LEFT OUTER JOIN
         progression_status T13 on T13.id=T12.progressionStatusId
		LEFT OUTER JOIN
	multi_language ml on ml.id = T10.correspondence_language
		LEFT OUTER JOIN    
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE T1.isCurrentPeriod=true AND T1.isCurrentSection=true AND T1.exitDate is null
AND T1.id in (namedParams)",'{
     "id": 1,
     "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "PROMOTION_STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },       
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "PROMOTION_STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "middleName",
            "resultKey": "PROMOTION_STUDENT_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
		{
            "id": 4,
            "value": "lastName",
            "resultKey": "PROMOTION_STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "code",
            "resultKey": "PROMOTION_STUDENT_ID",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "externalSysRefOne",
            "resultKey": "PROMOTION_EXTERNAL_REFERENCE_NUMBER_ONE",
            "displayCode": "",
            "displayOrder": 5
        },{
            "id": 7,
            "value": "salutationName",
            "resultKey": "PROMOTION_TITLE",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "initials",
            "resultKey": "PROMOTION_INITIAL",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "itemValue",
            "resultKey": "PROMOTION_ACADEMIC_TERM",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "displayName",
            "resultKey": "PROMOTION_ACADEMY_LOCATION",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "programNameToBePrint",
            "resultKey": "PROMOTION_PROGRAM",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "printName",
            "resultKey": "PROMOTION_BATCH",
            "displayCode": "",
            "displayOrder": 11
        },{
            "id": 13,
            "value": "printName",
            "resultKey": "PROMOTION_PERIOD",
            "displayCode": "",
            "displayOrder": 12
        },{
            "id": 14,
            "value": "itemValue",
            "resultKey": "PROMOTION_STATUS",
            "displayCode": "",
            "displayOrder": 13
        }
    ]
 }');
 
 SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
 SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='PROMOTION_STATUS_UPDATE_DL');
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
 
 SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='PROMOTION_STATUS_UPDATE');
 
 SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
 SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='PROMOTION_STATUS_UPDATE');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='PROMOTION_STATUS_UPDATE_RECIPIENT');
 SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');
 
 INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
 VALUES(@msgtemplateconfigId+1,'Promotion Status Update',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Promotion Status Update',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','','');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'2','','');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+3,@msgtemplateconfigId+1,'4','','');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+4,@msgtemplateconfigId+1,'6','','');

END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PROMOTION_STATUS_UPDATE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PROMOTION_STATUS_UPDATE', 'Promotion Status Update', 'Promotion Status Update', 'Promosiestatusopdatering', 'Cập nhật trạng thái khuyến mãi',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PROMOTION_STATUS_UPDATE_DL')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PROMOTION_STATUS_UPDATE_DL', 'Promotion Status Update DL', 'Promotion Status Update DL', 'Promosiestatusopdatering DL', 'Cập nhật trạng thái khuyến mãi DL',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PROMOTION_STATUS_UPDATE_RECIPIENT')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PROMOTION_STATUS_UPDATE_RECIPIENT', 'Promotion Status Update Recipient', 'Promotion Status Update Recipient', 'Ontvanger van promosiestatusopdatering', 'Cập nhật trạng thái khuyến mãi Người nhận',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='PROMOTION_STATUS_UPDATE')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('PROMOTION_STATUS_UPDATE', 'Promotion Status Update');
END IF;
  
IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='PROMOTION_STATUS_UPDATE_DL')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('PROMOTION_STATUS_UPDATE_DL', 'Promotion Status Update DL');
END IF;
  
IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='PROMOTION_STATUS_UPDATE_RECIPIENT')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('PROMOTION_STATUS_UPDATE_RECIPIENT', 'Promotion Status Update Recipient');
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PROMOTION_STUDENT_PRINT_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PROMOTION_STUDENT_PRINT_NAME', 'Student Print Name', 'Student Print Name', 'Student Druk Naam', 'Tên in hoa của học sinh',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PROMOTION_STUDENT_FIRST_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PROMOTION_STUDENT_FIRST_NAME', 'Student First Name', 'Student First Name', 'Student Voornaam', 'Tên học sinh',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PROMOTION_STUDENT_MIDDLE_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PROMOTION_STUDENT_MIDDLE_NAME', 'Student Middle Name', 'Student Middle Name', 'Student se middelnaam', 'Tên đệm của học sinh',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PROMOTION_STUDENT_LAST_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PROMOTION_STUDENT_LAST_NAME', 'Student Last Name', 'Student Last Name', 'Student Van Naam', 'Họ của học sinh',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PROMOTION_STUDENT_ID')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PROMOTION_STUDENT_ID', 'Student ID', 'Student ID', 'Studente ID', 'thẻ học sinh',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PROMOTION_EXTERNAL_REFERENCE_NUMBER_ONE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PROMOTION_EXTERNAL_REFERENCE_NUMBER_ONE', 'External Reference Number 1', 'External Reference Number 1', 'Eksterne verwysingsnommer 1', 'Số tham chiếu bên ngoài 1',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PROMOTION_TITLE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PROMOTION_TITLE', 'Title', 'Title', 'Titel', 'Tiêu đề',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PROMOTION_INITIAL')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PROMOTION_INITIAL', 'Initial', 'Initial', 'Aanvanklike', 'Ban đầu',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PROMOTION_ACADEMIC_TERM')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PROMOTION_ACADEMIC_TERM', 'Academic Term', 'Academic Term', 'Akademiese jaar', 'Năm học',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PROMOTION_ACADEMY_LOCATION')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PROMOTION_ACADEMY_LOCATION', 'Academy Location', 'Academy Location', 'Akademie ligging', 'Địa điểm học viện',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PROMOTION_PROGRAM')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PROMOTION_PROGRAM', 'Program', 'Program', 'Program', 'Chương trình',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PROMOTION_BATCH')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PROMOTION_BATCH', 'Batch', 'Batch', 'Batch', 'Lô',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PROMOTION_PERIOD')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PROMOTION_PERIOD', 'Period', 'Period', 'Tydperk', 'Giai đoạn',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='PROMOTION_STATUS')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'PROMOTION_STATUS', 'Promotion Status', 'Promotion Status', 'Bevordering Status', 'Trạng thái khuyến mãi',now(),1);
END IF;


END $$
CALL V20240909140535__Create_PromotionStatusUpdateEvent () $$ 
DROP PROCEDURE IF EXISTS V20240909140535__Create_PromotionStatusUpdateEvent $$ 
DELIMITER ;