DELIMITER $$
DROP PROCEDURE IF EXISTS get_method_level_data_for_avg $$
CREATE PROCEDURE get_method_level_data_for_avg(admissionIds text,batchId bigint)
BEGIN
SELECT DISTINCT
    methodRank.id AS id,
    methodRank.admissionId AS admissionId,
    methodRank.courseVariantId AS courseVariantId,
    seqHeader.id AS levelId,
    period.programBatchId AS batchId,
    methodRank.effectiveMarks AS effectiveMarks,
    methodRank.obtainedMarks AS obtainedMarks,
    seqHeader.sequenceName AS levelName
FROM
    evaluation_sequence_rank methodRank
        JOIN
    evaluation_sequence method ON method.id = methodRank.evaluationSequenceId
        JOIN
    sequence_header seqHeader ON seqHeader.id = method.evalSequenceId
        JOIN
    course_variants cv ON cv.id = methodRank.courseVariantId
        JOIN
    prog_batch_period_config period ON period.id = methodRank.periodId
WHERE
    (methodRank.whetherSpecialGrade IS NULL
        OR methodRank.whetherSpecialGrade = FALSE)
        AND (cv.whetherTransferCredits IS NULL
        OR cv.whetherTransferCredits = FALSE)
        AND period.programBatchId = batchId
        AND FIND_IN_SET(methodRank.admissionId, admissionIds);
END $$
DELIMITER ;