DELIMITER $$
DROP PROCEDURE IF EXISTS V20241024170701__Alter_TransactionDetailsNetsuite $$
CREATE PROCEDURE V20241024170701__Alter_TransactionDetailsNetsuite()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * from dtprovider where dataProviderName = "TRANSACTION_DETAILS_NETSUITE_RECIPIENT")) THEN 
SET @dtProviderId = (SELECT id from dtprovider where dataProviderName = "TRANSACTION_DETAILS_NETSUITE_RECIPIENT");
update sql_dtprovider
set sqlQuery = 
'
SELECT 
    T1.id AS ID,
	"External" AS FIRST_NAME,
	"User" AS LAST_NAME,
    T1.value AS EMAIL_ID,
    CURRENT_DATE
FROM 
    drop_down T1
WHERE 
    T1.type = "Netsuite_EmailID" and T1.id IN (namedParams)
'
where dataProviderId = @dtProviderId;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20241024170701__Alter_TransactionDetailsNetsuite() $$
DROP PROCEDURE IF EXISTS V20241024170701__Alter_TransactionDetailsNetsuite $$
DELIMITER ;


