DELIMITER $$
DROP PROCEDURE IF EXISTS d2l8Enrollments $$
CREATE PROCEDURE d2l8Enrollments()
BEGIN
SELECT
'type', 'action', 'child_code', 'role_name', 'parent_code'
 UNION
SELECT
'enrollment', 'UPDATE', users.id, 'Student', concat(sections.sectionCode,'-',sections.id)
from student_course_enrollment as enroll
join admission on enroll.admissionId=admission.id
join users on admission.studentId=users.id
join sections on enroll.sectionId = sections.id
join prog_batch_period_config as period on enroll.programBatchPeriodConfigId= period.id
JOIN academic_term ON period.academicTermId=academic_term.id AND academic_term.whetherCurrentAcademicTerm=true
join batches on period.programBatchId=batches.id
WHERE enroll.exitDate IS NULL AND admission.activeStatus=TRUE AND users.status=TRUE
UNION
SELECT
'enrollment', 'UPDATE', users.id, 'Teacher', concat(sections.sectionCode,'-',sections.id)
from prog_batch_course_faculty as pbFaculty
join users on pbFaculty.facultyId=users.id
join program_batch_course_param as param on pbFaculty.progBatchCourseParamId=param.id
join prog_batch_period_config as period on param.progBatchPeriodConfigId= period.id
join batches on period.programBatchId=batches.id
JOIN academic_term ON period.academicTermId=academic_term.id AND academic_term.whetherCurrentAcademicTerm=true
join sections on param.sectionId = sections.id
WHERE users.status=TRUE;
END $$
DELIMITER ;