DELIMITER $$
DROP PROCEDURE IF EXISTS V20241126144309__Create_quick_comment $$
CREATE PROCEDURE V20241126144309__Create_quick_comment()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='quick_comment')) THEN 
create table quick_comment (
id bigint not null AUTO_INCREMENT,
serviceRequestId bigint not null,
documentId bigint default null,
comments varchar(1000) not null,
isReadByAssignee bigint default false,
isReadByApproval bigint default false,
isReadByRequester bigint default false,
lastUpdatedBy bigint NOT NULL,
lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP on update current_timestamp,
PRIMARY KEY (id),
FOREIGN KEY (serviceRequestId) References service_requests(id),
FOREIGN KEY (documentId) References documents(id),
FOREIGN KEY (lastUpdatedBy) References users(id)
);
END IF; 

END $$
CALL V20241126144309__Create_quick_comment () $$ 
DROP PROCEDURE IF EXISTS V20241126144309__Create_quick_comment $$ 
DELIMITER ;