CREATE OR REPLACE VIEW `post_gl_poet_view` AS
    SELECT 
        FUNC_INC_VAR_SESSION_REC() AS `Id`,
        `abc`.`Academy_Location_Id` AS `Academy_Location_Id`,
        `abc`.`Academy_Name` AS `Academy_Name`,
        `abc`.`Location_Name` AS `Location_Name`,
        `abc`.`Academy_Location_Name` AS `Academy_Location_Name`,
        `abc`.`Admission_Id` AS `Admission_Id`,
        `abc`.`Student_Id` AS `Student_Id`,
        `abc`.`Student_Name` AS `Student_Name`,
        `abc`.`Batch_Name` AS `Batch_Name`,
        `abc`.`Program_Name` AS `Program_Name`,
        `abc`.`Payment_Number` AS `Payment_Number`,
        `abc`.`Bill_Receipt_Status` AS `Bill_Receipt_Status`,
        CAST(`abc`.`Date` AS DATE) AS `Date`,
        `abc`.`Category` AS `Category`,
        `abc`.`Amount` AS `Amount`,
        `abc`.`Fee_Head` AS `Fee_Head`,
        `abc`.`Fee_Stage_Name` AS `Fee_Stage_Name`,
        `abc`.`Fee_Plan_Type` AS `Fee_Plan_Type`,
        `abc`.`Fee_Plan_Name` AS `Fee_Plan_Name`,
        `abc`.`Scholarship_Name` AS `Scholarship_Name`,
        `abc`.`Cost_Center` AS `Cost_Center`,
        `abc`.`description` AS `description`,
        `abc`.`isControlAccount` AS `isControlAccount`,
        `abc`.`controlAccountId` AS `controlAccountId`,
        `abc`.`billGenerationType` AS `billGenerationType`,
        `abc`.`billedUserType` AS `billedUserType`,
        `abc`.`raiseBillType` AS `raiseBillType`,
        `abc`.`fundType` AS `fundType`,
        `abc`.`costCentreTransactionCode` AS `costCentreTransactionCode`
    FROM
        (SELECT DISTINCT
            `al`.`id` AS `Academy_Location_Id`,
                `al`.`academyName` AS `Academy_Name`,
                `al`.`locationName` AS `Location_Name`,
                `al`.`displayName` AS `Academy_Location_Name`,
                NULL AS `Admission_Id`,
                `usr`.`code` AS `Student_Id`,
                `usr`.`printName` AS `Student_Name`,
                `btc`.`batchName` AS `Batch_Name`,
                `prog`.`programName` AS `Program_Name`,
                `bh`.`billNo` AS `Payment_Number`,
                (CASE
                    WHEN (`bh`.`billStatus` = 'CANCELLED') THEN 'FULLY_PENDING'
                    ELSE `bh`.`billStatus`
                END) AS `Bill_Receipt_Status`,
                CAST(`bh`.`billingDate` AS DATE) AS `Date`,
                `bh`.`raiseBillCategory` AS `Category`,
                `bfp`.`billableAmount` AS `Amount`,
                `fh`.`feeHeadName` AS `Fee_Head`,
                `fsm`.`stageName` AS `Fee_Stage_Name`,
                `fpt`.`feePlanType` AS `Fee_Plan_Type`,
                `fp`.`feePlanName` AS `Fee_Plan_Name`,
                (CASE
                    WHEN (`bh`.`raiseBillCategory` = 'BILL_PAYABLE') THEN `dm`.`discountCode`
                    ELSE NULL
                END) AS `Scholarship_Name`,
                (CASE
                    WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN `cc`.`itemValue`
                    ELSE `ccd`.`itemValue`
                END) AS `Cost_Center`,
                (CASE
                    WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN `cc`.`description`
                    ELSE `ccd`.`description`
                END) AS `description`,
                (CASE
                    WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN `cc`.`isControlAccount`
                    ELSE `ccd`.`isControlAccount`
                END) AS `isControlAccount`,
                (CASE
                    WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN `cc`.`controlAccountId`
                    ELSE `ccd`.`controlAccountId`
                END) AS `controlAccountId`,
                `bh`.`billGenerationType` AS `billGenerationType`,
                `bt`.`billedUserType` AS `billedUserType`,
                `bt`.`raiseBillType` AS `raiseBillType`,
                (CASE
                    WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN `cc`.`fundType`
                    ELSE `ccd`.`fundType`
                END) AS `fundType`,
                NULL AS `costCentreTransactionCode`
        FROM
            ((((((((((((((((((((((`bill_header` `bh`
        JOIN `billed_user_type` `bt` ON ((`bt`.`id` = `bh`.`raiseBillFor`)))
        LEFT JOIN `users` `usr` ON ((`bh`.`studentId` = `usr`.`id`)))
        LEFT JOIN `students` `stu` ON ((`usr`.`id` = `stu`.`userId`)))
        LEFT JOIN `persons` `per` ON ((`stu`.`personId` = `per`.`id`)))
        LEFT JOIN `prog_batch_seat_config` `pbpc` ON ((`bh`.`programBatchSeatConfigId` = `pbpc`.`id`)))
        LEFT JOIN `batches` `btc` ON ((`pbpc`.`programBatchId` = `btc`.`id`)))
        LEFT JOIN `programs` `prog` ON ((`btc`.`programId` = `prog`.`id`)))
        LEFT JOIN `academy_location` `al` ON ((`bh`.`academyLocationId` = `al`.`id`)))
        LEFT JOIN `bill_fee_plan_rule_stage` `bfp` ON ((`bh`.`id` = `bfp`.`billId`)))
        LEFT JOIN `applicant_student_discount_master` `asdm` ON (((`bh`.`studentId` = `asdm`.`studentId`)
            AND (`bh`.`programBatchSeatConfigId` = `asdm`.`programBatchSeatConfigId`))))
        LEFT JOIN `discount_master` `dm` ON ((`asdm`.`discountMasterId` = `dm`.`id`)))
        LEFT JOIN `fee_stage_head_config` `fshc` ON ((`bfp`.`feeStageHeadConfigId` = `fshc`.`id`)))
        LEFT JOIN `fee_stage_head_config` `pfshc` ON ((`fshc`.`parentFeeHeadId` = `pfshc`.`id`)))
        LEFT JOIN `cost_centre` `cc` ON ((0 <> (CASE
            WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN (`cc`.`id` = `fshc`.`costCentreId`)
            ELSE (`cc`.`id` = `pfshc`.`costCentreId`)
        END))))
        LEFT JOIN `cost_centre` `ccd` ON ((`ccd`.`id` = `pfshc`.`discountCostCentreId`)))
        LEFT JOIN `fee_heads` `fh` ON ((`fshc`.`feeHeadId` = `fh`.`id`)))
        LEFT JOIN `fee_plan_rule_stage` `fprs` ON ((`fshc`.`feePlanRuleStageId` = `fprs`.`id`)))
        LEFT JOIN `fee_plan_rules` `fpr` ON ((`fpr`.`id` = `fprs`.`feePlanRuleId`)))
        LEFT JOIN `fee_plan` `fp` ON ((`fp`.`id` = `fpr`.`feePlanId`)))
        LEFT JOIN `fee_stage_master` `fsm` ON ((`fprs`.`stageId` = `fsm`.`id`)))
        LEFT JOIN `fee_plan_type` `fpt` ON ((`fsm`.`feePlanType` = `fpt`.`id`)))
        JOIN `analytics_all_poet_transactions_view` `ccpd` ON ((`ccpd`.`billHeaderId` = `bh`.`id`)))
        WHERE
            ((`usr`.`id` IS NOT NULL)
                AND (`bh`.`applicantId` IS NULL)
                AND (`bh`.`totalAmount` IS NOT NULL)) UNION SELECT DISTINCT
            `al`.`id` AS `Academy_Location_Id`,
                `al`.`academyName` AS `Academy_Name`,
                `al`.`locationName` AS `Location_Name`,
                `al`.`displayName` AS `Academy_Location_Name`,
                NULL AS `Admission_Id`,
                `a`.`code` AS `Student_Id`,
                `ap`.`printName` AS `Student_Name`,
                `b`.`batchName` AS `Batch_Name`,
                `pro`.`programName` AS `Program_Name`,
                `bh`.`billNo` AS `Payment_Number`,
                (CASE
                    WHEN (`bh`.`billStatus` = 'CANCELLED') THEN 'FULLY_PENDING'
                    ELSE `bh`.`billStatus`
                END) AS `Bill_Receipt_Status`,
                CAST(`bh`.`billingDate` AS DATE) AS `Date`,
                `bh`.`raiseBillCategory` AS `Category`,
                `bfp`.`billableAmount` AS `Amount`,
                `fh`.`feeHeadName` AS `Fee_Head`,
                `fsm`.`stageName` AS `Fee_Stage_Name`,
                `fpt`.`feePlanType` AS `Fee_Plan_Type`,
                `fp`.`feePlanName` AS `Fee_Plan_Name`,
                (CASE
                    WHEN (`bh`.`raiseBillCategory` = 'BILL_PAYABLE') THEN `dm`.`discountCode`
                    ELSE NULL
                END) AS `Scholarship_Name`,
                (CASE
                    WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN `cc`.`itemValue`
                    ELSE `ccd`.`itemValue`
                END) AS `Cost_Center`,
                (CASE
                    WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN `cc`.`description`
                    ELSE `ccd`.`description`
                END) AS `description`,
                (CASE
                    WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN `cc`.`isControlAccount`
                    ELSE `ccd`.`isControlAccount`
                END) AS `isControlAccount`,
                (CASE
                    WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN `cc`.`controlAccountId`
                    ELSE `ccd`.`controlAccountId`
                END) AS `controlAccountId`,
                `bh`.`billGenerationType` AS `billGenerationType`,
                `bt`.`billedUserType` AS `billedUserType`,
                `bt`.`raiseBillType` AS `raiseBillType`,
                (CASE
                    WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN `cc`.`fundType`
                    ELSE `ccd`.`fundType`
                END) AS `fundType`,
                NULL AS `costCentreTransactionCode`
        FROM
            (((((((((((((((((((((`bill_header` `bh`
        JOIN `billed_user_type` `bt` ON ((`bt`.`id` = `bh`.`raiseBillFor`)))
        LEFT JOIN `application` `a` ON ((`a`.`id` = `bh`.`applicantId`)))
        LEFT JOIN `applicant_person` `ap` ON ((`ap`.`id` = `a`.`applicantPersonId`)))
        LEFT JOIN `academy_location` `al` ON ((`al`.`id` = `bh`.`academyLocationId`)))
        LEFT JOIN `prog_batch_seat_config` `pbsc` ON ((`bh`.`programBatchSeatConfigId` = `pbsc`.`id`)))
        LEFT JOIN `batches` `b` ON ((`pbsc`.`programBatchId` = `b`.`id`)))
        LEFT JOIN `programs` `pro` ON ((`b`.`programId` = `pro`.`id`)))
        LEFT JOIN `bill_fee_plan_rule_stage` `bfp` ON ((`bh`.`id` = `bfp`.`billId`)))
        LEFT JOIN `applicant_student_discount_master` `asdm` ON (((`bh`.`applicantId` = `asdm`.`applicantId`)
            AND (`bh`.`programBatchSeatConfigId` = `asdm`.`programBatchSeatConfigId`))))
        LEFT JOIN `discount_master` `dm` ON ((`asdm`.`discountMasterId` = `dm`.`id`)))
        LEFT JOIN `fee_stage_head_config` `fshc` ON ((`bfp`.`feeStageHeadConfigId` = `fshc`.`id`)))
        LEFT JOIN `fee_stage_head_config` `pfshc` ON ((`fshc`.`parentFeeHeadId` = `pfshc`.`id`)))
        LEFT JOIN `cost_centre` `cc` ON ((0 <> (CASE
            WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN (`cc`.`id` = `fshc`.`costCentreId`)
            ELSE (`cc`.`id` = `pfshc`.`costCentreId`)
        END))))
        LEFT JOIN `cost_centre` `ccd` ON ((`ccd`.`id` = `pfshc`.`discountCostCentreId`)))
        LEFT JOIN `fee_heads` `fh` ON ((`fshc`.`feeHeadId` = `fh`.`id`)))
        LEFT JOIN `fee_plan_rule_stage` `fprs` ON ((`fshc`.`feePlanRuleStageId` = `fprs`.`id`)))
        LEFT JOIN `fee_plan_rules` `fpr` ON ((`fpr`.`id` = `fprs`.`feePlanRuleId`)))
        LEFT JOIN `fee_plan` `fp` ON ((`fp`.`id` = `fpr`.`feePlanId`)))
        LEFT JOIN `fee_stage_master` `fsm` ON ((`fprs`.`stageId` = `fsm`.`id`)))
        LEFT JOIN `fee_plan_type` `fpt` ON ((`fsm`.`feePlanType` = `fpt`.`id`)))
        JOIN `analytics_all_poet_transactions_view` `ccpd` ON ((`ccpd`.`billHeaderId` = `bh`.`id`)))
        WHERE
            ((`ap`.`id` IS NOT NULL)
                AND (`bh`.`totalAmount` IS NOT NULL)) UNION SELECT DISTINCT
            `al`.`id` AS `Academy_Location_Id`,
                `al`.`academyName` AS `Academy_Name`,
                `al`.`locationName` AS `Location_Name`,
                `al`.`displayName` AS `Academy_Location_Name`,
                NULL AS `Admission_Id`,
                `usr`.`code` AS `Student_Id`,
                `usr`.`printName` AS `Student_Name`,
                `btc`.`batchName` AS `Batch_Name`,
                `prog`.`programName` AS `Program_Name`,
                `bh`.`billNo` AS `Payment_Number`,
                `bh`.`billStatus` AS `Bill_Receipt_Status`,
                CAST(`bh`.`cancellationDate` AS DATE) AS `Date`,
                `bh`.`raiseBillCategory` AS `Category`,
                `bfp`.`billableAmount` AS `Amount`,
                `fh`.`feeHeadName` AS `Fee_Head`,
                `fsm`.`stageName` AS `Fee_Stage_Name`,
                `fpt`.`feePlanType` AS `Fee_Plan_Type`,
                `fp`.`feePlanName` AS `Fee_Plan_Name`,
                (CASE
                    WHEN (`bh`.`raiseBillCategory` = 'BILL_PAYABLE') THEN `dm`.`discountCode`
                    ELSE NULL
                END) AS `Scholarship_Name`,
                (CASE
                    WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN `cc`.`itemValue`
                    ELSE `ccd`.`itemValue`
                END) AS `Cost_Center`,
                (CASE
                    WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN `cc`.`description`
                    ELSE `ccd`.`description`
                END) AS `description`,
                (CASE
                    WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN `cc`.`isControlAccount`
                    ELSE `ccd`.`isControlAccount`
                END) AS `isControlAccount`,
                (CASE
                    WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN `cc`.`controlAccountId`
                    ELSE `ccd`.`controlAccountId`
                END) AS `controlAccountId`,
                `bh`.`billGenerationType` AS `billGenerationType`,
                `bt`.`billedUserType` AS `billedUserType`,
                `bt`.`raiseBillType` AS `raiseBillType`,
                (CASE
                    WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN `cc`.`fundType`
                    ELSE `ccd`.`fundType`
                END) AS `fundType`,
                NULL AS `costCentreTransactionCode`
        FROM
            ((((((((((((((((((((((`bill_header` `bh`
        JOIN `billed_user_type` `bt` ON ((`bt`.`id` = `bh`.`raiseBillFor`)))
        LEFT JOIN `users` `usr` ON ((`bh`.`studentId` = `usr`.`id`)))
        LEFT JOIN `students` `stu` ON ((`usr`.`id` = `stu`.`userId`)))
        LEFT JOIN `persons` `per` ON ((`stu`.`personId` = `per`.`id`)))
        LEFT JOIN `prog_batch_seat_config` `pbpc` ON ((`bh`.`programBatchSeatConfigId` = `pbpc`.`id`)))
        LEFT JOIN `batches` `btc` ON ((`pbpc`.`programBatchId` = `btc`.`id`)))
        LEFT JOIN `programs` `prog` ON ((`btc`.`programId` = `prog`.`id`)))
        LEFT JOIN `academy_location` `al` ON ((`bh`.`academyLocationId` = `al`.`id`)))
        LEFT JOIN `bill_fee_plan_rule_stage` `bfp` ON ((`bh`.`id` = `bfp`.`billId`)))
        LEFT JOIN `applicant_student_discount_master` `asdm` ON (((`bh`.`studentId` = `asdm`.`studentId`)
            AND (`bh`.`programBatchSeatConfigId` = `asdm`.`programBatchSeatConfigId`))))
        LEFT JOIN `discount_master` `dm` ON ((`asdm`.`discountMasterId` = `dm`.`id`)))
        LEFT JOIN `fee_stage_head_config` `fshc` ON ((`bfp`.`feeStageHeadConfigId` = `fshc`.`id`)))
        LEFT JOIN `fee_stage_head_config` `pfshc` ON ((`fshc`.`parentFeeHeadId` = `pfshc`.`id`)))
        LEFT JOIN `cost_centre` `cc` ON ((0 <> (CASE
            WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN (`cc`.`id` = `fshc`.`costCentreId`)
            ELSE (`cc`.`id` = `pfshc`.`costCentreId`)
        END))))
        LEFT JOIN `cost_centre` `ccd` ON ((`ccd`.`id` = `pfshc`.`discountCostCentreId`)))
        LEFT JOIN `fee_heads` `fh` ON ((`fshc`.`feeHeadId` = `fh`.`id`)))
        LEFT JOIN `fee_plan_rule_stage` `fprs` ON ((`fshc`.`feePlanRuleStageId` = `fprs`.`id`)))
        LEFT JOIN `fee_plan_rules` `fpr` ON ((`fpr`.`id` = `fprs`.`feePlanRuleId`)))
        LEFT JOIN `fee_plan` `fp` ON ((`fp`.`id` = `fpr`.`feePlanId`)))
        LEFT JOIN `fee_stage_master` `fsm` ON ((`fprs`.`stageId` = `fsm`.`id`)))
        LEFT JOIN `fee_plan_type` `fpt` ON ((`fsm`.`feePlanType` = `fpt`.`id`)))
        JOIN `analytics_all_poet_transactions_view` `ccpd` ON ((`ccpd`.`billHeaderId` = `bh`.`id`)))
        WHERE
            ((`usr`.`id` IS NOT NULL)
                AND (`bh`.`applicantId` IS NULL)
                AND (`bh`.`totalAmount` IS NOT NULL)
                AND (`bh`.`billStatus` = 'CANCELLED')) UNION SELECT DISTINCT
            `al`.`id` AS `Academy_Location_Id`,
                `al`.`academyName` AS `Academy_Name`,
                `al`.`locationName` AS `Location_Name`,
                `al`.`displayName` AS `Academy_Location_Name`,
                NULL AS `Admission_Id`,
                `a`.`code` AS `Student_Id`,
                `ap`.`printName` AS `Student_Name`,
                `b`.`batchName` AS `Batch_Name`,
                `pro`.`programName` AS `Program_Name`,
                `bh`.`billNo` AS `Payment_Number`,
                `bh`.`billStatus` AS `Bill_Receipt_Status`,
                CAST(`bh`.`cancellationDate` AS DATE) AS `Date`,
                `bh`.`raiseBillCategory` AS `Category`,
                `bfp`.`billableAmount` AS `Amount`,
                `fh`.`feeHeadName` AS `Fee_Head`,
                `fsm`.`stageName` AS `Fee_Stage_Name`,
                `fpt`.`feePlanType` AS `Fee_Plan_Type`,
                `fp`.`feePlanName` AS `Fee_Plan_Name`,
                (CASE
                    WHEN (`bh`.`raiseBillCategory` = 'BILL_PAYABLE') THEN `dm`.`discountCode`
                    ELSE NULL
                END) AS `Scholarship_Name`,
                (CASE
                    WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN `cc`.`itemValue`
                    ELSE `ccd`.`itemValue`
                END) AS `Cost_Center`,
                (CASE
                    WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN `cc`.`description`
                    ELSE `ccd`.`description`
                END) AS `description`,
                (CASE
                    WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN `cc`.`isControlAccount`
                    ELSE `ccd`.`isControlAccount`
                END) AS `isControlAccount`,
                (CASE
                    WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN `cc`.`controlAccountId`
                    ELSE `ccd`.`controlAccountId`
                END) AS `controlAccountId`,
                `bh`.`billGenerationType` AS `billGenerationType`,
                `bt`.`billedUserType` AS `billedUserType`,
                `bt`.`raiseBillType` AS `raiseBillType`,
                (CASE
                    WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN `cc`.`fundType`
                    ELSE `ccd`.`fundType`
                END) AS `fundType`,
                NULL AS `costCentreTransactionCode`
        FROM
            (((((((((((((((((((((`bill_header` `bh`
        JOIN `billed_user_type` `bt` ON ((`bt`.`id` = `bh`.`raiseBillFor`)))
        LEFT JOIN `application` `a` ON ((`a`.`id` = `bh`.`applicantId`)))
        LEFT JOIN `applicant_person` `ap` ON ((`ap`.`id` = `a`.`applicantPersonId`)))
        LEFT JOIN `academy_location` `al` ON ((`al`.`id` = `bh`.`academyLocationId`)))
        LEFT JOIN `prog_batch_seat_config` `pbsc` ON ((`bh`.`programBatchSeatConfigId` = `pbsc`.`id`)))
        LEFT JOIN `batches` `b` ON ((`pbsc`.`programBatchId` = `b`.`id`)))
        LEFT JOIN `programs` `pro` ON ((`b`.`programId` = `pro`.`id`)))
        LEFT JOIN `bill_fee_plan_rule_stage` `bfp` ON ((`bh`.`id` = `bfp`.`billId`)))
        LEFT JOIN `applicant_student_discount_master` `asdm` ON (((`bh`.`applicantId` = `asdm`.`applicantId`)
            AND (`bh`.`programBatchSeatConfigId` = `asdm`.`programBatchSeatConfigId`))))
        LEFT JOIN `discount_master` `dm` ON ((`asdm`.`discountMasterId` = `dm`.`id`)))
        LEFT JOIN `fee_stage_head_config` `fshc` ON ((`bfp`.`feeStageHeadConfigId` = `fshc`.`id`)))
        LEFT JOIN `fee_stage_head_config` `pfshc` ON ((`fshc`.`parentFeeHeadId` = `pfshc`.`id`)))
        LEFT JOIN `cost_centre` `cc` ON ((0 <> (CASE
            WHEN (`fshc`.`parentFeeHeadId` IS NULL) THEN (`cc`.`id` = `fshc`.`costCentreId`)
            ELSE (`cc`.`id` = `pfshc`.`costCentreId`)
        END))))
        LEFT JOIN `cost_centre` `ccd` ON ((`ccd`.`id` = `pfshc`.`discountCostCentreId`)))
        LEFT JOIN `fee_heads` `fh` ON ((`fshc`.`feeHeadId` = `fh`.`id`)))
        LEFT JOIN `fee_plan_rule_stage` `fprs` ON ((`fshc`.`feePlanRuleStageId` = `fprs`.`id`)))
        LEFT JOIN `fee_plan_rules` `fpr` ON ((`fpr`.`id` = `fprs`.`feePlanRuleId`)))
        LEFT JOIN `fee_plan` `fp` ON ((`fp`.`id` = `fpr`.`feePlanId`)))
        LEFT JOIN `fee_stage_master` `fsm` ON ((`fprs`.`stageId` = `fsm`.`id`)))
        LEFT JOIN `fee_plan_type` `fpt` ON ((`fsm`.`feePlanType` = `fpt`.`id`)))
        JOIN `analytics_all_poet_transactions_view` `ccpd` ON ((`ccpd`.`billHeaderId` = `bh`.`id`)))
        WHERE
            ((`ap`.`id` IS NOT NULL)
                AND (`bh`.`totalAmount` IS NOT NULL)
                AND (`bh`.`billStatus` = 'CANCELLED'))) `abc`;