DELIMITER $$
DROP PROCEDURE IF EXISTS V20241128141729__Update_AddColumnThesisManagementGrid $$
CREATE PROCEDURE V20241128141729__Update_AddColumnThesisManagementGrid()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from data_grid where gridName='Academia.view.examinationcenters.thesisManagement.ThesisManagementGrid' AND portalId=1)) THEN 
UPDATE `data_grid` SET `jsonObject` = '[{"id":null,"columnName":"ACADEMY_LOCATION","dataIndex":"academyLocation","columnVisibility":"SHOW","sequence":1,"mandatory":false},
 {"id":null,"columnName":"ADMISSION_ID","dataIndex":"admissionCode","columnVisibility":"HIDE","sequence":2,"mandatory":false},
 {"id":null,"columnName":"STUDENT_ID","dataIndex":"studentCode","columnVisibility":"SHOW","sequence":3,"mandatory":false},
 {"id":null,"columnName":"EXTERNAL_REFERENCE_ONE","dataIndex":"externalRefNoOne","columnVisibility":"SHOW","sequence":4,"mandatory":false},
 {"id":null,"columnName":"STUDENT_NAME","dataIndex":"studentName","columnVisibility":"SHOW","sequence":5,"mandatory":false},
 {"id":null,"columnName":"PROGRAM","dataIndex":"programName","columnVisibility":"SHOW","sequence":6,"mandatory":false},
 {"id":null,"columnName":"BATCH","dataIndex":"batchName","columnVisibility":"SHOW","sequence":7,"mandatory":false},
 {"id":null,"columnName":"PERIOD","dataIndex":"periodName","columnVisibility":"SHOW","sequence":8,"mandatory":false},
 {"id":null,"columnName":"NOMINATOR","dataIndex":"nominatorName","columnVisibility":"SHOW","sequence":9,"mandatory":false},
 {"id":null,"columnName":"CEREMONY_ID_NAME","dataIndex":"ceremonyIdAndName","columnVisibility":"SHOW","sequence":10,"mandatory":false},
 {"id":null,"columnName":"CEREMONY_DATE","dataIndex":"ceremonydate","columnVisibility":"SHOW","sequence":11,"mandatory":false},
 {"id":null,"columnName":"THESIS_STATUS","dataIndex":"thesisStatus","columnVisibility":"SHOW","sequence":12,"mandatory":false},
 {"id":null,"columnName":"SUPERVISIOR","dataIndex":"supervisorName","columnVisibility":"HIDE","sequence":13,"mandatory":false},
 {"id":null,"columnName":"THESIS_DOCUMENT","dataIndex":"thesisDocument","columnVisibility":"SHOW","sequence":14,"mandatory":false}]'
 where gridName='Academia.view.examinationcenters.thesisManagement.ThesisManagementGrid' AND portalId=1;
END IF; 

IF NOT EXISTS (( SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' AND keyName='EXTERNAL_REFERENCE_ONE')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,lastUpdate,lastUpdatedBy) 
VALUES ('TRANSLATIONS', 'EXTERNAL_REFERENCE_ONE', 'External Reference Number 1', 'External Reference Number 1', 'Eksterne verwysingsnommer 1', 'Số tham chiếu bên ngoài 1',now(),1);
END IF;

IF NOT EXISTS (( SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' AND keyName='NOMINATOR')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,lastUpdate,lastUpdatedBy) 
VALUES ('TRANSLATIONS', 'NOMINATOR', 'Nominator', 'Nominator', 'Nomineerder', 'Người đề cử',now(),1);
END IF;

IF NOT EXISTS (( SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' AND keyName='CEREMONY_ID_NAME')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,lastUpdate,lastUpdatedBy) 
VALUES ('TRANSLATIONS', 'CEREMONY_ID_NAME', 'Graduation Ceremony ID/Name', 'Graduation Ceremony ID/Name', 'Gradeplegtigheid ID/Naam', 'Lễ tốt nghiệp ID/Tên',now(),1);
END IF;

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20241128141729__Update_AddColumnThesisManagementGrid () $$
DROP PROCEDURE IF EXISTS V20241128141729__Update_AddColumnThesisManagementGrid $$
DELIMITER ;