DELIMITER $$
DROP PROCEDURE IF EXISTS V20241210193522__Update_CourseEnrollInfoAddDataProvider $$
CREATE PROCEDURE V20241210193522__Update_CourseEnrollInfoAddDataProvider()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO' limit 1)) THEN 
update dydt_data_line_item set resultColumnsDef  ='COURSE_CODE, COURSE_NAME, COURSE_CREDITS, PERIOD, EXAM_DATE, EXAM_START_TIME, EXAM_END_TIME,YEARLY_MODULE',
sqlSelectQueryDef =  "SELECT IFNULL(co.courseCode, c.courseCode) AS COURSE_CODE,
    IFNULL(co.courseName, c.courseName) AS COURSE_NAME,
FLOOR ( c.courseCredits) 
AS COURSE_CREDITS, 
pbpc.printName AS PERIOD , ss.examDate AS EXAM_DATE, 
DATE_FORMAT(ss.examStartTime,'%h:%i %p') AS EXAM_START_TIME, 
DATE_FORMAT(ss.examEndTime,'%h:%i %p') 
AS EXAM_END_TIME,IF(program_courses.isOfferedYearly = 1,
        'Yes',
        'No') AS YEARLY_MODULE
from student_course_enrollment sce
inner 
join prog_batch_period_config pbpc on sce.programBatchPeriodConfigId=pbpc.id
inner join period_year py on pbpc.periodYearId=py.id
inner 
join admission adm on adm.id=sce.admissionId
inner join course_variants cv on cv.id=sce.courseVarientId
INNER JOIN sections ss on ss.id = sce.sectionId

left join courses c on c.id=cv.courseId
LEFT JOIN courses co ON co.id = c.parentCourseId
LEFT JOIN program_courses ON c.parentCourseId = program_courses.courseId AND pbpc.programBatchId = program_courses.programBatchId"
where dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO';

SET @dydtdatalinitemId=(select min(id) from dydt_data_line_item where dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO');
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES 
('YEARLY_MODULE', 'Yearly Module',@dydtdatalinitemId);

END IF; 

IF EXISTS ((select * from dydt_data_line_item where dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO_2' limit 1)) THEN 
update dydt_data_line_item set resultColumnsDef  ='COURSE_CODE, COURSE_NAME, COURSE_CREDITS, PERIOD, EXAM_DATE, EXAM_START_TIME, EXAM_END_TIME,YEARLY_MODULE',
sqlSelectQueryDef =  "SELECT IFNULL(co.courseCode, c.courseCode) AS COURSE_CODE,
    IFNULL(co.courseName, c.courseName) AS COURSE_NAME,
FLOOR ( c.courseCredits) 
AS COURSE_CREDITS, 
pbpc.printName AS PERIOD , ss.examDate AS EXAM_DATE, 
DATE_FORMAT(ss.examStartTime,'%h:%i %p') AS EXAM_START_TIME, 
DATE_FORMAT(ss.examEndTime,'%h:%i %p') 
AS EXAM_END_TIME,IF(program_courses.isOfferedYearly = 1,
        'Yes',
        'No') AS YEARLY_MODULE
from student_course_enrollment sce
inner 
join prog_batch_period_config pbpc on sce.programBatchPeriodConfigId=pbpc.id
inner join period_year py on pbpc.periodYearId=py.id
inner 
join admission adm on adm.id=sce.admissionId
inner join course_variants cv on cv.id=sce.courseVarientId
INNER JOIN sections ss on ss.id = sce.sectionId

left join courses c on c.id=cv.courseId
LEFT JOIN courses co ON co.id = c.parentCourseId
LEFT JOIN program_courses ON c.parentCourseId = program_courses.courseId AND pbpc.programBatchId = program_courses.programBatchId"
where dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO_2';

SET @dydtdatalinitemId=(select min(id) from dydt_data_line_item where dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO_2');
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES 
('YEARLY_MODULE', 'Yearly Module',@dydtdatalinitemId);

END IF; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20241210193522__Update_CourseEnrollInfoAddDataProvider () $$
DROP PROCEDURE IF EXISTS V20241210193522__Update_CourseEnrollInfoAddDataProvider $$
DELIMITER ;