DROP TRIGGER IF EXISTS `hr_emp_leave_request_detail_AFTER_UPDATE`;
DELIMITER $$
CREATE TRIGGER `hr_emp_leave_request_detail_AFTER_UPDATE` AFTER UPDATE ON `hr_emp_leave_request_detail` FOR EACH ROW BEGIN
update
    employee_daily_attendance
        LEFT JOIN 
    hr_emp_leave_request ON hr_emp_leave_request.requestUserId = employee_daily_attendance.staffId
    left join  hr_leave_type on hr_emp_leave_request.hrLeaveTypeId=hr_leave_type.id
set employee_daily_attendance.hrLeaveTypeId=hr_leave_type.id
WHERE
    hr_emp_leave_request.status = 'APPROVED' and employee_daily_attendance.hrLeaveTypeId is null and employee_daily_attendance.attendanceDate=date(now())
        AND employee_daily_attendance.attendanceDate BETWEEN hr_emp_leave_request.fromDate AND hr_emp_leave_request.toDate;
END$$
DELIMITER ;