DELIMITER $$
DROP PROCEDURE IF EXISTS V20241223160358__Alter_AddCountryOnIdentityDetail $$
CREATE PROCEDURE V20241223160358__Alter_AddCountryOnIdentityDetail()
BEGIN

IF NOT EXISTS (
    SELECT * 
    FROM information_schema.COLUMNS 
    WHERE TABLE_SCHEMA = DATABASE() 
      AND TABLE_NAME = 'identity_detail' 
      AND COLUMN_NAME = 'countryId'
) THEN
    ALTER TABLE identity_detail
    ADD COLUMN countryId BIGINT DEFAULT NULL;
END IF;

IF NOT EXISTS (
    SELECT * 
    FROM information_schema.referential_constraints 
    WHERE constraint_schema = DATABASE() 
      AND TABLE_NAME = 'identity_detail' 
      AND CONSTRAINT_NAME = 'FK_country'
) THEN
    ALTER TABLE identity_detail
    ADD CONSTRAINT FK_country FOREIGN KEY (countryId) REFERENCES country(id);
END IF;

END $$
CALL V20241223160358__Alter_AddCountryOnIdentityDetail() $$
DROP PROCEDURE IF EXISTS V20241223160358__Alter_AddCountryOnIdentityDetail $$
DELIMITER ;