DELIMITER $$
DROP PROCEDURE IF EXISTS V20250122155434__Create_ProgramLearningOutcomeCSM $$
CREATE PROCEDURE V20250122155434__Create_ProgramLearningOutcomeCSM()
BEGIN

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'PROGRAM_LEARNING_OUTCOME')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'program_learning_outcome_csm','PROGRAM_LEARNING_OUTCOME','Program & Courses','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;



SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId+1 and fieldLabel = 'PROGRAM')) THEN
INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'program', 'PROGRAM', @standardMasterMaxId+1, 'Varchar', '1', b'1', 'programs', 'id', 'programName', b'0', b'0', b'0', '1', now());
END IF;


SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId+1 and fieldLabel = 'PROGRAM_LEARNING_OUTCOME_NAME')) THEN
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `maxLength`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'programLearningOutcomeName', 'PROGRAM_LEARNING_OUTCOME_NAME', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '100', '1', now());
END IF;

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId+1 and fieldLabel = 'PROGRAM_LEARNING_OUTCOME_DESCRIPTION')) THEN
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `maxLength`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'programLearningOutcomeDescription', 'PROGRAM_LEARNING_OUTCOME_DESCRIPTION', @standardMasterMaxId+1, 'TextArea', '3', 0, 0, 0, 1, '512', '1', now());
END IF;

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId+1 and fieldLabel = 'STATUS')) THEN
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`,`emunType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
 VALUES (@ItemsMaxId + 1, 'status', 'STATUS', @standardMasterMaxId+1, 'Enum','DUBLIN_DESCRIPTORS_ACTIVE_INACTIVE','4',false, 0, 0, 0, '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'PROGRAM_LEARNING_OUTCOME')) THEN 
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
	VALUES ('masterNames', 'PROGRAM_LEARNING_OUTCOME', 'Program Learning Outcome', 'Program Learning Outcome','Program Leeruitkoms','Kết quả học tập của chương trình',now(),1);
	END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'PROGRAM_LEARNING_OUTCOME_NAME')) THEN 
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
	VALUES ('TRANSLATIONS', 'PROGRAM_LEARNING_OUTCOME_NAME', 'Program Learning Outcome Name', 'Program Learning Outcome Name','Program Leeruitkoms Naam','Tên kết quả học tập của chương trình',now(),1);
	END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'PROGRAM')) THEN 
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
	VALUES ('TRANSLATIONS', 'PROGRAM', 'Program', 'Program','Program','Chương trình',now(),1);
	END IF;


IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'PROGRAM_LEARNING_OUTCOME_DESCRIPTION')) THEN 
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
	VALUES ('TRANSLATIONS', 'PROGRAM_LEARNING_OUTCOME_DESCRIPTION', 'Program Learning Outcome Description', 'Program Learning Outcome Description','Program Leeruitkoms Beskrywing','Mô tả kết quả học tập của chương trình',now(),1);
	END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'STATUS')) THEN 
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
	VALUES ('TRANSLATIONS', 'STATUS', 'Status', 'Status','Status','Trạng thái',now(),1);
	END IF; 


END $$
CALL V20250122155434__Create_ProgramLearningOutcomeCSM () $$ 
DROP PROCEDURE IF EXISTS V20250122155434__Create_ProgramLearningOutcomeCSM $$ 
DELIMITER ;