DELIMITER $$
DROP PROCEDURE IF EXISTS V20250207182637__Update_submitApplicationOrPaidForBuzzEvent $$
CREATE PROCEDURE V20250207182637__Update_submitApplicationOrPaidForBuzzEvent()
BEGIN
set  @dtprovider=(select id from dtprovider where dataProviderName="APPLICATION_SUBMIT_BUZZ_RECIPIENT");
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from sql_dtprovider where dataProviderId=@dtprovider)) THEN 
UPDATE sql_dtprovider 
SET sqlQuery="select T4.id AS ID,
T1.`code` AS APPLICATION_ID,
 	T2.`firstName` AS APPLICANT_FIRST_NAME,
	T2.`lastName` AS APPLICANT_LAST_NAME,
	T21.`salutationName` AS PARENT_SALUTATION,
    T20.`firstName` AS PARENT_FIRST_NAME,
     T20.`lastName` AS PARENT_LAST_NAME,
 	T2.`emailId` AS EMAIL_ID,
 	T2.`mobileNumber` AS MOBILE_NO,
    T2.`shortName` AS APPLICANT_OTHER_NAME,
     T5.displayName AS ACADEMY_NAME_LOCATION,
     T5.academyName AS ACADEMY_NAME,
     T5.locationName AS LOCATION_NAME,
     CONCAT(T7.phoneCountryCode,'-',T7.phoneAreaCode,'-',T7.phoneNo) AS ACADEMY_LOCATION_PHONE_NUMBER,
     T7.primaryeEmailId AS ACADEMY_LOCATION_EMAIL,
     T11.programName AS PROGRAM_NAME,
     T13.batchName AS INTAKE,
     T18.seatName AS SEAT_TYPE,
         (CASE
         WHEN
             T5.headerUrl IS NOT NULL
                 AND org.orgUrl IS NOT NULL
         THEN
             CONCAT(org.orgUrl, '/', T5.headerUrl)
         ELSE NULL
     END) AS HEADER_URL,
     (CASE
         WHEN
             T5.footerUrl IS NOT NULL
                 AND org.orgUrl IS NOT NULL
         THEN
             CONCAT(org.orgUrl, '/', T5.footerUrl)
         ELSE NULL
     END) AS FOOTER_URL,
     (CASE
         WHEN
             T5.logoUrl IS NULL
                 AND org.orgUrl IS NOT NULL
         THEN
             CONCAT(org.orgUrl,
                     '/',
                     'emailer/images/logo_default_image.png')
         WHEN
             T5.logoUrl IS NULL
                 AND org.orgUrl IS NULL
         THEN
             'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
         ELSE CONCAT(org.orgUrl, '/', T5.logoUrl)
     END) AS LOGO_URL,
     T7.websiteURL AS ACADEMY_LOCATION_WEBSITE_URL,
T2.`firstName` AS FIRST_NAME,
T2.`lastName` AS LAST_NAME
     from application_program T4
 		left outer join
     application T1 on T4.applicationId = T1.id
 		left outer join
     applicant_person T2 on T1.applicantPersonId=T2.id
 		LEFT OUTER JOIN
        applicant_person_relationships T19 on (T19.applicantPersonId=T2.id and T19.relationship in ('FATHER','MOTHER') and T19.whetherDeleted=false)
        LEFT OUTER JOIN
        applicant_person as T20 on T20.id=T19.relatedApplicantPersonId
          LEFT OUTER JOIN
          salutations as T21 on T21.id=T20.salutationId
       LEFT OUTER JOIN
     academy_location T5 ON T5.id = T4.academyLocationId
 		LEFT OUTER JOIN
     academy_location_addresses T6 ON T6.academyLocationId = T5.id
 		LEFT OUTER JOIN
     address T7 ON T7.id = T6.addressId && T7.addressTypeId=10
 		LEFT OUTER JOIN
 	city T8 ON T8.id = T7.cityId
 		LEFT OUTER JOIN
 	country T9 ON T9.id = T8.countryId
 		LEFT OUTER JOIN
 	country_region T10 ON T10.id = T8.countryRegionId
 		LEFT OUTER JOIN
 	programs T11 ON T11.id = T4.programId		
 		LEFT JOIN       
     prog_batch_seat_config T17 on T17.id = T4.progBatchSeatConfigId
     LEFT JOIN
 	batches T13 ON T13.programId=T11.id and T13.id = T17.programBatchId
      LEFT JOIN
     seat_types T18 ON T18.id = T17.seatTypeId
      LEFT JOIN
 	users T14 ON T14.id=T1.applicationOwner
 		LEFT JOIN
     staffs T15 ON T15.userId = T14.id
         LEFT JOIN
     persons T16 ON T16.id = T15.personId
 		LEFT JOIN
     multi_language ml ON ml.id = T2.correspondence_language
 		LEFT OUTER JOIN
     organizations org ON org.id = (SELECT 
             MAX(id)
         FROM
             organizations)
     where T4.id in(namedParams) order by T19.relationship asc limit 1;
     " , jsonString='{
     "id": 1,
     "searchResultViewColumns": [
 		{
             "id": 1,
             "value": "code",
             "resultKey": "APPLICATION_ID",
             "displayCode": "",
             "displayOrder": 0
         },
         {
             "id": 2,
             "value": "firstName",
             "resultKey": "APPLICANT_FIRST_NAME",
             "displayCode": "",
             "displayOrder": 1
         },
         {
             "id": 3,
             "value": "lastName",
             "resultKey": "APPLICANT_LAST_NAME",
             "displayCode": "",
             "displayOrder": 2
         },
            {
             "id": 4,
             "value": "salutationName",
             "resultKey": "PARENT_SALUTATION",
             "displayCode": "",
             "displayOrder": 3
         },
            {
             "id": 5,
             "value": "firstName",
             "resultKey": "PARENT_FIRST_NAME",
             "displayCode": "",
             "displayOrder": 4
         },
            {
             "id": 6,
             "value": "lastName",
             "resultKey": "PARENT_LAST_NAME",
             "displayCode": "",
             "displayOrder": 5
         },
 		{
             "id": 7,
             "value": "emailId",
             "resultKey": "EMAIL_ID",
             "displayCode": "",
             "displayOrder": 6
         },
 		{
             "id": 8,
             "value": "mobileNumber",
             "resultKey": "MOBILE_NO",
             "displayCode": "",
             "displayOrder": 7
         },
         	{
             "id": 9,
             "value": "shortName",
             "resultKey": "APPLICANT_OTHER_NAME",
             "displayCode": "",
             "displayOrder": 8
         },
          {
             "id": 10,
             "value": "academyName",
             "resultKey": "ACADEMY_NAME",
             "displayCode": "",
             "displayOrder": 9
         },
         {
             "id": 11,
             "value": "displayName",
             "resultKey": "ACADEMY_NAME_LOCATION",
             "displayCode": "",
             "displayOrder": 10
         },
         {
             "id": 12,
             "value": "locationName",
             "resultKey": "LOCATION_NAME",
             "displayCode": "",
             "displayOrder": 11
         
         },
         {
             "id": 13,
             "value": "programName",
             "resultKey": "PROGRAM_NAME",
             "displayCode": "",
             "displayOrder": 12
         },
         {
             "id": 14,
             "value": "batchName",
             "resultKey": "INTAKE",
             "displayCode": "",
             "displayOrder": 13
         },
 		{
             "id": 15,
             "value": "seatName",
             "resultKey": "SEAT_TYPE",
             "displayCode": "",
             "displayOrder": 14
         },
         {
             "id": 16,
             "value": "logoUrl",
             "resultKey": "LOGO_URL",
             "displayCode": "",
             "displayOrder": 15
         },
 		 {
             "id": 17,
             "value": "headerUrl",
             "resultKey": "HEADER_URL",
             "displayCode": "",
             "displayOrder": 16
         },
 		 {
             "id": 18,
             "value": "footerUrl",
             "resultKey": "FOOTER_URL",
             "displayCode": "",
             "displayOrder": 17
         },
 		 {
             "id": 19,
             "value": "ACADEMY_LOCATION_PHONE_NO",
             "resultKey": "ACADEMY_LOCATION_PHONE_NUMBER",
             "displayCode": "",
             "displayOrder": 18
         },
 		 {
             "id": 20,
             "value": "primaryeEmailId",
             "resultKey": "ACADEMY_LOCATION_EMAIL",
             "displayCode": "",
             "displayOrder": 19
         },
         {
             "id": 21,
             "value": "websiteURL",
             "resultKey": "ACADEMY_LOCATION_WEBSITE_URL",
             "displayCode": "",
             "displayOrder": 20
         },
         {
             "id": 22,
             "value": "firstName",
             "resultKey": "FIRST_NAME",
             "displayCode": "",
             "displayOrder": 21
         },
         {
             "id": 23,
             "value": "lastName",
             "resultKey": "LAST_NAME",
             "displayCode": "",
             "displayOrder": 22
         }
     ]
 }'
WHERE dataProviderId=@dtprovider;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250207182637__Update_submitApplicationOrPaidForBuzzEvent () $$
DROP PROCEDURE IF EXISTS V20250207182637__Update_submitApplicationOrPaidForBuzzEvent $$
DELIMITER ;