DELIMITER $$
DROP PROCEDURE IF EXISTS V20250225125605__Create_EnquiryUtmDetails $$
CREATE PROCEDURE V20250225125605__Create_EnquiryUtmDetails()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='enq_utm_detail')) THEN 
CREATE TABLE IF NOT EXISTS `enq_utm_detail` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
    `enquiryId` BIGINT(20) NOT NULL, 
	`createdAt` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `lsCode` VARCHAR(255) DEFAULT NULL,
    `utmSource` VARCHAR(255) DEFAULT NULL,
    `utmMedium` VARCHAR(255) DEFAULT NULL,
    `utmCampaign` VARCHAR(255) DEFAULT NULL,
    `utmContent` VARCHAR(255) DEFAULT NULL,
    `adId` VARCHAR(255) DEFAULT NULL,
    `adSetId` VARCHAR(255) DEFAULT NULL,
    `campaignId` VARCHAR(255) DEFAULT NULL,
    `adName` VARCHAR(255) DEFAULT NULL,
    `adSetName` VARCHAR(255) DEFAULT NULL,
    `placement` VARCHAR(255) DEFAULT NULL,
    `siteSourceName` VARCHAR(255) DEFAULT NULL,
    `utmUrl` VARCHAR(1000) DEFAULT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
    FOREIGN KEY (`enquiryId`) REFERENCES `enquiry`(`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
    INDEX idx_enq_utm_detail_enquiryId (`enquiryId`),
    CONSTRAINT `fk_enq_utm_detail_enquiryId` FOREIGN KEY (`enquiryId`)  REFERENCES `enquiry` (`id`)  ON DELETE NO ACTION  ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20250225125605__Create_EnquiryUtmDetails () $$ 
DROP PROCEDURE IF EXISTS V20250225125605__Create_EnquiryUtmDetails $$ 
DELIMITER ;