DELIMITER $$

DROP PROCEDURE IF EXISTS V20250304134957__Insert_PublishTimetableTranslation $$
CREATE PROCEDURE V20250304134957__Insert_PublishTimetableTranslation()
BEGIN

    -- Check and insert TIMETABLE_PUBLISH_SUCCESS if it does not exist
    IF NOT EXISTS (SELECT 1 FROM `ui_translation` WHERE objectName='EXAMINATION' AND keyName='TIMETABLE_PUBLISH_SUCCESS') THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,lastUpdate,lastUpdatedBy)
        VALUES ('EXAMINATION', 'TIMETABLE_PUBLISH_SUCCESS', 'Timetable Published Successfully', 'Timetable Published Successfully', 
                'Rooster Suksesvol gepubliseer', 'Lịch trình đã được xuất bản thành công', NOW(), 1);
    END IF;

    -- Check and insert STUDENTS_ARE_NOT_MAPPED if it does not exist
    IF NOT EXISTS (SELECT 1 FROM `ui_translation` WHERE objectName='EXAMINATION' AND keyName='STUDENTS_ARE_NOT_MAPPED') THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,lastUpdate,lastUpdatedBy)
        VALUES ('EXAMINATION', 'STUDENTS_ARE_NOT_MAPPED', 'Students are not mapped in the Room', 'Students are not mapped in the Room', 
                'Studente word nie in die Kamer gekarteer nie', 'Học sinh không được lập bản đồ trong Phòng', NOW(), 1);
    END IF;

END $$

CALL V20250304134957__Insert_PublishTimetableTranslation() $$

DROP PROCEDURE IF EXISTS V20250304134957__Insert_PublishTimetableTranslation $$

DELIMITER ;
