DELIMITER $$
DROP PROCEDURE IF EXISTS V20250418134756__Alter_ScholarshipNominateOrAward_main $$
CREATE PROCEDURE V20250418134756__Alter_ScholarshipNominateOrAward_main()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND 
table_name='scholarship_nominate_or_award' AND column_name='progBatchPeriodConfigId')) THEN 
Alter table scholarship_nominate_or_award
add column progBatchPeriodConfigId bigint null default null
after batchId;
END IF;

IF EXISTS (
    SELECT * 
    FROM information_schema.columns 
    WHERE table_schema = DATABASE() 
      AND table_name = 'scholarship_nominate_or_award' 
      AND column_name = 'progBatchPeriodConfigId'
) THEN
    IF NOT EXISTS (
        SELECT * 
        FROM information_schema.table_constraints 
        WHERE table_schema = DATABASE()
          AND table_name = 'scholarship_nominate_or_award'
          AND constraint_name = 'FK_ProgBatchPeriodConfSchNomiOrAward'
          AND constraint_type = 'FOREIGN KEY'
    ) THEN
        ALTER TABLE scholarship_nominate_or_award
        ADD CONSTRAINT FK_ProgBatchPeriodConfSchNomiOrAward
        FOREIGN KEY (progBatchPeriodConfigId) REFERENCES prog_batch_period_config(id);
    END IF;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND 
table_name='scholarship_nominate_or_award' AND column_name='admissionId')) THEN 
Alter table scholarship_nominate_or_award
add column admissionId bigint null default null
after studentId;
END IF;

IF EXISTS (
    SELECT * 
    FROM information_schema.columns 
    WHERE table_schema = DATABASE() 
      AND table_name = 'scholarship_nominate_or_award' 
      AND column_name = 'admissionId'
) THEN
    IF NOT EXISTS (
        SELECT * 
        FROM information_schema.table_constraints 
        WHERE table_schema = DATABASE()
          AND table_name = 'scholarship_nominate_or_award'
          AND constraint_name = 'FK_AdmissionSchNomiOrAward'
          AND constraint_type = 'FOREIGN KEY'
    ) THEN
        ALTER TABLE scholarship_nominate_or_award
        ADD CONSTRAINT FK_AdmissionSchNomiOrAward
        FOREIGN KEY (admissionId) REFERENCES admission(id);
    END IF;
END IF;

END $$
CALL V20250418134756__Alter_ScholarshipNominateOrAward_main() $$
DROP PROCEDURE IF EXISTS V20250418134756__Alter_ScholarshipNominateOrAward_main $$
DELIMITER ;