DELIMITER $$
DROP PROCEDURE IF EXISTS V20250421143115__Insert_MAKINI_ID_CARD_VELOCITY $$
CREATE PROCEDURE V20250421143115__Insert_MAKINI_ID_CARD_VELOCITY()
BEGIN

SET @reportTempId = (select max(id) FROM report_type WHERE typeName ='Student ID Card');
	
IF not EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'MAKINI_IDENTITY_CARD_VELOCITY')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTempId, 'MAKINI_IDENTITY_CARD_VELOCITY', 'Makini Identity Card', 'MAKINI_IDENTITY_CARD_VELOCITY.png', 'MAKINI_IDENTITY_CARD_VELOCITY_COMMONREPORT.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'MAKINI_IDENTITY_CARD_VELOCITY.jasper', 'AcademiaLogo.png');
END IF; 

set @tempId = (select max(id) from report_template where templateCode='MAKINI_IDENTITY_CARD_VELOCITY' and templateName='Makini Identity Card');

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_STD_CARD') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_STD_CARD', 'STUDENT CARD', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_STD_NAME1') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_STD_NAME1', 'Name', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_STD_NUM1') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_STD_NUM1', 'SD No', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_STD_NUM2') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_STD_NUM2', 'Student Number:', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_STD_NAME2') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_STD_NAME2', 'Student Name:', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_GRADE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_GRADE', 'Grade:', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_INTAKE_YEAR') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_INTAKE_YEAR', 'Intake Year:', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_STD_STATUS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_STD_STATUS', 'Student status:', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_IF_LOST') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_IF_LOST', 'If lost and found send to', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_OR_CALL') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_OR_CALL', 'or Call', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_JUNIOR_SCHOOL') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_JUNIOR_SCHOOL', '(Junior school)', '1', now());
END IF;

END $$
CALL V20250421143115__Insert_MAKINI_ID_CARD_VELOCITY() $$
DROP PROCEDURE IF EXISTS V20250421143115__Insert_MAKINI_ID_CARD_VELOCITY $$
DELIMITER ;