DELIMITER $$
DROP PROCEDURE IF EXISTS V20250429175755__Insert_ProgressionExamEventMainHistory  $$
CREATE PROCEDURE V20250429175755__Insert_ProgressionExamEventMainHistory()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='progression_panel_exam_event_main_history')) THEN 
CREATE TABLE `progression_panel_exam_event_main_history` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `progressionPanelDecisionId` BIGINT NOT NULL,
  `academicTermId` BIGINT NOT NULL,
  `progressionPanelExamEventId` BIGINT NOT NULL,
  `progressionStatusId` BIGINT NULL DEFAULT NULL,
  `sendStatus` BIT NOT NULL DEFAULT b'0',
  `subjectLine` VARCHAR(255),
  `systemGeneratedMsgContent` BLOB,
  `userGeneratedMsgContent` BLOB,
  `ramark` TEXT,
  `progressionStatusCode` VARCHAR(100),
  `marksheetJobId` BIGINT,
  `marksheetPath` TEXT,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  
  PRIMARY KEY (`id`),
  INDEX `fk_pp_progressionPanelDecisionId_idx` (`progressionPanelDecisionId` ASC),
  INDEX `fk_pp_academicTermId_idx` (`academicTermId` ASC),
  INDEX `fk_pp_progressionStatusId_idx` (`progressionStatusId` ASC),
  INDEX `fk_pp_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
  INDEX `fk_pp_marksheetJobId_idx` (`marksheetJobId` ASC),
  INDEX `fk_pp_progressionPanelExamEventId_idx` (`progressionPanelExamEventId` ASC),
  
  
    CONSTRAINT `fk_pp_progressionPanelDecisionId`
    FOREIGN KEY (`progressionPanelDecisionId`)
    REFERENCES `progression_panel_decision_template` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,

   CONSTRAINT `fk_pp_academicTermId`
    FOREIGN KEY (`academicTermId`)
    REFERENCES `academic_term` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,

    CONSTRAINT `fk_pp_progressionStatusId`
    FOREIGN KEY (`progressionStatusId`)
    REFERENCES `progression_status` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,

    CONSTRAINT `fk_pp_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,
    
    CONSTRAINT `fk_pp_marksheetJobId`
    FOREIGN KEY (`marksheetJobId`)
    REFERENCES `marksheet_job_details` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,
    
    CONSTRAINT `fk_pp_progressionPanelExamEventId`
    FOREIGN KEY (`progressionPanelExamEventId`)
    REFERENCES `progression_panel_exam_event` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION
) ;

END IF; 

END $$
CALL V20250429175755__Insert_ProgressionExamEventMainHistory() $$
DROP PROCEDURE IF EXISTS V20250429175755__Insert_ProgressionExamEventMainHistory $$
DELIMITER ;