DELIMITER $$
DROP PROCEDURE IF EXISTS V20250513123933__Insert_ProgramSpecificInitiativeCSM $$
CREATE PROCEDURE V20250513123933__Insert_ProgramSpecificInitiativeCSM()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='program_specific_initiative')) THEN 
CREATE TABLE `program_specific_initiative` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`itemCode` VARCHAR(255) NOT NULL,
	`itemValue` VARCHAR(255) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- CSM Data --

SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'PROGRAM_SPECIFIC_INITIATIVE')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'program_specific_initiative','PROGRAM_SPECIFIC_INITIATIVE','Program & Courses','COMMON_MASTER',0,0,NULL,1,now());

IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterMaxId+1 and fieldLabel='ITEM_CODE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('code','ITEM_CODE',@standardMasterMaxId+1,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;

IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterMaxId+1 and fieldLabel='ITEM_VALUE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('value','ITEM_VALUE',@standardMasterMaxId+1,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;

END IF;

-- TRANSLATION --

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'PROGRAM_SPECIFIC_INITIATIVE')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'PROGRAM_SPECIFIC_INITIATIVE', 'Program Specific Initiative', 'Program Specific Initiative','Programspesifieke inisiatief','Sáng kiến ​​cụ thể của chương trình',now(),1);
END IF;

END IF; 

END $$
CALL V20250513123933__Insert_ProgramSpecificInitiativeCSM() $$
DROP PROCEDURE IF EXISTS V20250513123933__Insert_ProgramSpecificInitiativeCSM $$
DELIMITER ;