DELIMITER $$
DROP PROCEDURE IF EXISTS V20250520174955__Create_ProgramQualificationMapping $$
CREATE PROCEDURE V20250520174955__Create_ProgramQualificationMapping()
BEGIN
IF NOT EXISTS ((SELECT * FROM information_schema.tables    WHERE table_schema = DATABASE() AND table_name = 'program_qualification_mapping')) THEN 
CREATE TABLE `program_qualification_mapping` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `hesaSubjectId` BIGINT NOT NULL,
  `qualificationIttSpecialismId` BIGINT NOT NULL,
  `programId`  BIGINT NOT NULL,
  `programRoleProportion` double  DEFAULT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  
  PRIMARY KEY (`id`),
  INDEX `fk_program_qualification_mapping_hesaSubjectId_idx` (`hesaSubjectId` ASC),
  INDEX `fk_program_qualification_mapping_programId_idx` (`programId` ASC),
   INDEX `fk_program_qualification_mapping_qualificationSpecialismId_idx` (`qualificationIttSpecialismId` ASC),
  INDEX `fk_program_qualification_mapping_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
 

  CONSTRAINT `fk_program_qualification_mapping_hesaSubjectId`
    FOREIGN KEY (`hesaSubjectId`)
    REFERENCES `hesa_subject` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,

CONSTRAINT `fk_program_qualification_mapping_programId`
    FOREIGN KEY (`programId`)
    REFERENCES `programs` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,
    
    CONSTRAINT `fk_program_qualification_mapping_qualificationIttSpecialismId`
    FOREIGN KEY (`qualificationIttSpecialismId`)
    REFERENCES `qualification_specialism` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,
    
  CONSTRAINT `fk_program_qualification_mapping_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION
    
) ;

END IF;


END $$
CALL V20250520174955__Create_ProgramQualificationMapping () $$ 
DROP PROCEDURE IF EXISTS V20250520174955__Create_ProgramQualificationMapping $$ 
DELIMITER ; 