DELIMITER $$
DROP PROCEDURE IF EXISTS V20250526110320__Insert_DisciplinaryActionEvent $$
CREATE PROCEDURE V20250526110320__Insert_DisciplinaryActionEvent()
BEGIN

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='DISCIPLINARY_ACTION_NOTIFICATION')) THEN 

-- =======================Messaging event: Event Reminder Schedule=============================================
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='ADMISSION');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'DISCIPLINARY_ACTION_NOTIFICATION'); 

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='DISCIPLINARY_ACTION_NOTIFICATION');

INSERT INTO `system_msg_event` (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '2', @msgSubCategoryId, 'DISCIPLINARY_ACTION', 'Disciplinary Action', 'SYSTEM_SCHEDULE', 0, 0, 0, 0, 1, 0, 0, 'Disciplinary Action');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'DISCIPLINARY_ACTION_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'DISCIPLINARY_ACTION_RCPNT', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DISCIPLINARY_ACTION_RCPNT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'DISCIPLINARY_ACTION_RCPNT');

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DISCIPLINARY_ACTION_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='DISCIPLINARY_ACTION_RCPNT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DISCIPLINARY_ACTION_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    daa.id AS USER_ID,
    T17.id AS ACADEMY_LOCATION_IDS
FROM
   disciplinary_action_details_su daa 
 LEFT JOIN
   persons T1 on T1.id = daa.personId
        LEFT JOIN
    students T2 ON T2.personId = T1.id
        LEFT JOIN
    users T3 ON T3.id = T2.userId
    LEFT JOIN 
    user_academy_locations ual on ual.userId=T3.id and ual.whetherPrimary=true
        LEFT JOIN
    academy_location T17 ON T17.id = ual.academyLocationId
    
   where daa.id =(namedParams) <MSG@ACAD_LOC_CRITERIA> AND ual.academyLocationId IN (msg_scope_acad_loc_Ids)</MSG>",NULL);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DISCIPLINARY_ACTION_RCPNT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`,`sqlQuery`, `jsonString`) 
VALUES (@sqlDtproviderId+1,@dtproviderId,
"select 
daa.id AS ID,
mt.itemValue AS TYPE_OF_MISCONDUCT,
date_format(da.dateOfMisconduct, '%d-%m-%Y') AS DATE_OF_MISCONDUCT,
ad.misConductDetails AS MISCONDUCT_DETAIL,
T3.code AS STUDENT_ID,
T1.mobileCountryCode AS MOBILE_COUNTRY_CODE,
T1.mobileNumber AS MOBILE_NO,
T1.emailId AS EMAIL_ID,
T1.alternateEmailId AS ALTERNATE_EMAIL_ID,
T1.printName AS STUDENT_NAME,
T1.firstName AS FIRST_NAME,
T1.middleName AS MIDDLE_NAME,
T1.lastName AS LAST_NAME,
T17.displayName AS BRAND_CAMPUS_NAME,
T18.academyName AS BRAND_NAME,
T19.locationName AS CAMPUS_NAME,
T23.primaryeEmailId AS CAMPUS_EMAIL_ID,
aa.websiteURL AS BRAND_CAMPUS_WEBSITE,
concat(T23.addressText,',',T24.cityName,',',T25.countryName,',',T26.countryRegionName,',',T23.pincode)  AS CAMPUS_ADDRESS,
T24.cityName AS CAMPUS_CITY,
T25.countryName AS CAMPUS_COUNTRY,
T26.countryRegionName AS CAMPUS_COUNTRY_REGION,
T23.pincode AS CAMPUS_POSTAL_CODE,
concat(T23.phoneCountryCode,'',T23.phoneAreaCode,'',T23.phoneNo)  AS CAMPUS_PHONE_NUMBER,
concat(T23.cellCountryCode,'',T23.cellNo)  AS CAMPUS_MOBILE_NUMBER,
T23.primaryeEmailId AS CAMPUS_PRIMARY_EMAIL_ID,
T23.alternateEmailId AS CAMPUS_ALTERNATE_EMAIL_ID,
 (CASE
        WHEN
            T17.logoUrl IS NULL
                AND T21.orgUrl IS NOT NULL
        THEN
            CONCAT(T21.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T17.logoUrl IS NULL
                AND T21.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(T21.orgUrl, '/', T17.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T17.headerUrl IS NOT NULL
                AND T21.orgUrl IS NOT NULL
        THEN
            CONCAT(T21.orgUrl, '/', T17.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T17.footerUrl IS NOT NULL
                AND T21.orgUrl IS NOT NULL
        THEN
            CONCAT(T21.orgUrl, '/', T17.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL
 FROM
   disciplinary_action_details_su daa 
   LEFT JOIN 
   disciplinary_actions_su da on daa.disciplinaryActionId=da.id
   LEFT JOIN 
   misconduct_type mt on mt.id=da.misConductTypeId
   LEFT JOIN  
   appeal_details_su ad on ad.disciplinaryActionId=da.id
   LEFT JOIN 
    persons T1 on T1.id = daa.personId
        LEFT JOIN
    students T2 ON T2.personId = T1.id
        LEFT JOIN
    users T3 ON T3.id = T2.userId
    LEFT JOIN 
    user_academy_locations ual on ual.userId=T3.id and ual.whetherPrimary=true
        LEFT JOIN
    academy_location T17 ON T17.id = ual.academyLocationId
       LEFT JOIN 
    academy_location_addresses ala ON ala.academyLocationId=T17.id
    LEFT JOIN 
    address aa ON aa.id=ala.addressId and aa.addressTypeId=10
	LEFT JOIN
    academies T18 ON T18.id = T17.academyId
	 LEFT JOIN
    organizations T21 ON T21.id = T18.organizationId
        LEFT JOIN
    locations T19 ON T19.id = T17.locationId
           LEFT JOIN
	location_addresses la on la.locationId=T19.id
    LEFT JOIN 
    address T23 ON T23.id = la.addressId
        LEFT JOIN
    city T24 ON T24.id = T23.cityId
        LEFT JOIN
    country T25 ON T25.id = T24.countryId
        LEFT JOIN
    country_region T26 ON T26.id = T24.countryRegionId
          WHERE
     daa.id in (namedParams)",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "itemValue",
            "resultKey": "TYPE_OF_MISCONDUCT",
            "displayCode": "",
            "displayOrder": 1
        },
	 {
            "id": 3,
            "value": "dateOfMisconduct",
            "resultKey": "DATE_OF_MISCONDUCT",
            "displayCode": "",
            "displayOrder": 2
        },
	 {
            "id": 4,
            "value": "misConductDetails",
            "resultKey": "MISCONDUCT_DETAIL",
            "displayCode": "",
            "displayOrder": 3
        },{
            "id": 5,
            "value": "code",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 4
        },{
            "id": 6,
            "value": "printName",
            "resultKey": "STUDENT_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "alternateEmailId",
            "resultKey": "ALTERNATE_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
	 {
            "id": 13,
            "value": "displayName",
            "resultKey": "BRAND_CAMPUS_NAME",
            "displayCode": "",
            "displayOrder": 12
        },
	 {
            "id": 14,
            "value": "academyName",
            "resultKey": "BRAND_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
	 {
            "id": 15,
            "value": "locationName",
            "resultKey": "CAMPUS_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
	 {
            "id": 16,
            "value": "primaryeEmailId",
            "resultKey": "CAMPUS_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 15
        },
	 {
            "id": 17,
            "value": "websiteURL",
            "resultKey": "BRAND_CAMPUS_WEBSITE",
            "displayCode": "",
            "displayOrder": 16
        },
	 {
            "id": 18,
            "value": "CAMPUS_ADDRESS",
            "resultKey": "CAMPUS_ADDRESS",
            "displayCode": "",
            "displayOrder": 17
        },
        {
            "id": 19,
            "value": "cityName",
            "resultKey": "CAMPUS_CITY",
            "displayCode": "",
            "displayOrder": 18
        },
        {
            "id": 20,
            "value": "countryName",
            "resultKey": "CAMPUS_COUNTRY",
            "displayCode": "",
            "displayOrder": 19
        },
        {
            "id": 21,
            "value": "countryRegionName",
            "resultKey": "CAMPUS_COUNTRY_REGION",
            "displayCode": "",
            "displayOrder": 20
        },
	 {
            "id": 22,
            "value": "pincode",
            "resultKey": "CAMPUS_POSTAL_CODE",
            "displayCode": "",
            "displayOrder": 21
        },
	 {
            "id": 23,
            "value": "phoneNo",
            "resultKey": "CAMPUS_PHONE_NUMBER",
            "displayCode": "",
            "displayOrder": 22
        },
	 {
            "id": 24,
            "value": "cellNo",
            "resultKey": "CAMPUS_MOBILE_NUMBER",
            "displayCode": "",
            "displayOrder": 23
        },
	 {
            "id": 25,
            "value": "primaryeEmailId",
            "resultKey": "CAMPUS_PRIMARY_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 24
        },
	 {
            "id": 26,
            "value": "alternateEmailId",
            "resultKey": "CAMPUS_ALTERNATE_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 25
        } ,
        {
            "id": 27,
            "value": "logoURL",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 26
        },
        {
            "id": 28,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 27
        },
        {
            "id": 29,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 28
        } ,
        {
            "id": 30,
            "value": "mobileCountryCode",
            "resultKey": "MOBILE_COUNTRY_CODE",
            "displayCode": "",
            "displayOrder": 29
        }     
    ]
}');


SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='DISCIPLINARY_ACTION_DL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='DISCIPLINARY_ACTION');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='DISCIPLINARY_ACTION_NOTIFICATION');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='DISCIPLINARY_ACTION_RCPNT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`) 
VALUES(@msgtemplateconfigId+1,'Disciplinary Action',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,4,NULL,NULL,'Disciplinary Action',NULL,'',NULL,'','APPROVED','','1','System Admin','1','English');

INSERT INTO `msg_template` (`msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateconfigId+1,'1',"$recipientData[&quot;TYPE_OF_MISCONDUCT&quot;]",'');

INSERT INTO `msg_template` (`msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateconfigId+1,'2','NULL','');

INSERT INTO `msg_template` (`msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateconfigId+1,'4',"$recipientData[&quot;TYPE_OF_MISCONDUCT&quot;]",'');


-- Start :  setting of dynamic document

SET @dydtdocumenttypeId=(SELECT MAX(id) FROM `dydt_document_type`);
INSERT INTO `dydt_document_type` (`id`,`typeName`, `configLevelCode`, `whetherDeletable`, `typeCode`, `availableForAdhoc`, `whetherEditable`) 
VALUES (@dydtdocumenttypeId+1,'Disciplinary Action', 'ACADEMY_LOCATION_LEVEL', '0', 'Disciplinary Action', '0', '1');

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @sysmsgevtrcpntdocId=(SELECT MAX(id) FROM `sys_msg_evt_rcpnt_doc`);
SET @msgscopeparamId=(select id from msg_scope_param where paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_rcpnt_doc`(`id`,`sysMsgEvtRcpntDefaultConfigId`,`docTypeId`,`docGenOwnerMappingDef`,`docGenParamMapDef`)
VALUES(@sysmsgevtrcpntdocId+1,@sysmsgevtrcptdefaultconfId,@dydtdocumenttypeId+1,@msgscopeparamId,'[{"MSG_PARAM":"CONTEXT_RECORD_ID","DOC_GEN_PARAM":"PRM_DISCIPLINARY_ACTION_DETAIL_SU_ID"}]');

-- Start : Mapping of Dynamic Document to MsgTemplate

SET @msgtemplateconfigdocId=(SELECT MAX(id) FROM `msg_template_config_doc`);
INSERT INTO `msg_template_config_doc` (`id`,`msgTemplateconfigId`, `sysMsgEvtRcpntdocId`) VALUES (@msgtemplateconfigdocId+1,@msgtemplateconfigId+1,@sysmsgevtrcpntdocId+1);

-- End : Mapping of Dynamic Document to Msgtemplate

SET @dydtdataproviderId=(SELECT MAX(id) FROM `dydt_data_provider`);
INSERT INTO `dydt_data_provider` (`id`,`providerName`, `priority`) VALUES (@dydtdataproviderId+1,'Disciplinary Action', '1');

SET @dydtdocumentdataproviderId=(SELECT MAX(id) FROM `dydt_document_data_provider`);
INSERT INTO `dydt_document_data_provider` (`id`,`dataProviderId`, `documentTypeId`) VALUES (@dydtdocumentdataproviderId+1,@dydtdataproviderId+1, @dydtdocumenttypeId+1);

-- COMPLETE_ADMISSION_INPUT_PARAMETER this is first data provider for document gen

SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, 
`sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) 
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId+1, 'DISCIPLINARY_ACTION_INFO', '1',null,'1', '1', 
'select 
T3.id AS ID,
mt.itemValue AS TYPE_OF_MISCONDUCT,
date_format(da.dateOfMisconduct, "%d-%m-%Y") AS DATE_OF_MISCONDUCT,
ad.misConductDetails AS MISCONDUCT_DETAIL,
T3.code AS STUDENT_ID,
T1.mobileCountryCode AS MOBILE_COUNTRY_CODE,
T1.mobileNumber AS MOBILE_NO,
T1.emailId AS EMAIL_ID,
T1.alternateEmailId AS SECONDARY_EMAIL_ID,
T1.printName AS STUDENT_NAME,
T1.firstName AS FIRST_NAME,
T1.middleName AS MIDDLE_NAME,
T1.lastName AS LAST_NAME,
T17.displayName AS BRAND_CAMPUS_NAME,
T18.academyName AS BRAND_NAME,
T19.locationName AS CAMPUS_NAME,
T23.primaryeEmailId AS CAMPUS_EMAIL_ID,
aa.websiteURL AS BRAND_CAMPUS_WEBSITE,
concat(T23.addressText,",",T24.cityName,",",T25.countryName,",",T26.countryRegionName,",",T23.pincode)  AS CAMPUS_ADDRESS,
T24.cityName AS CAMPUS_CITY,
T25.countryName AS CAMPUS_COUNTRY,
T26.countryRegionName AS CAMPUS_COUNTRY_REGION,
T23.pincode AS CAMPUS_POSTAL_CODE,
concat(T23.phoneCountryCode,"",T23.phoneAreaCode,"",T23.phoneNo)  AS CAMPUS_PHONE_NUMBER,
concat(T23.cellCountryCode,"",T23.cellNo)  AS CAMPUS_MOBILE_NUMBER,
T23.primaryeEmailId AS CAMPUS_PRIMARY_EMAIL_ID,
T23.alternateEmailId AS CAMPUS_ALTERNATE_EMAIL_ID,
T17.logoUrl AS LOGO_URL,
  T17.headerUrl AS HEADER_URL,
    T17.footerUrl AS FOOTER_URL
 FROM
   disciplinary_action_details_su daa 
   LEFT JOIN 
   disciplinary_actions_su da on daa.disciplinaryActionId=da.id
   LEFT JOIN 
   misconduct_type mt on mt.id=da.misConductTypeId
   LEFT JOIN  
   appeal_details_su ad on ad.disciplinaryActionId=da.id
   LEFT JOIN 
    persons T1 on T1.id = daa.personId
        LEFT JOIN
    students T2 ON T2.personId = T1.id
        LEFT JOIN
    users T3 ON T3.id = T2.userId
    LEFT JOIN 
    user_academy_locations ual on ual.userId=T3.id and ual.whetherPrimary=true
        LEFT JOIN
    academy_location T17 ON T17.id = ual.academyLocationId
       LEFT JOIN 
    academy_location_addresses ala ON ala.academyLocationId=T17.id
    LEFT JOIN 
    address aa ON aa.id=ala.addressId and aa.addressTypeId=10
	LEFT JOIN
    academies T18 ON T18.id = T17.academyId
	 LEFT JOIN
    organizations T21 ON T21.id = T18.organizationId
        LEFT JOIN
    locations T19 ON T19.id = T17.locationId
           LEFT JOIN
	location_addresses la on la.locationId=T19.id
    LEFT JOIN 
    address T23 ON T23.id = la.addressId
        LEFT JOIN
    city T24 ON T24.id = T23.cityId
        LEFT JOIN
    country T25 ON T25.id = T24.countryId
        LEFT JOIN
    country_region T26 ON T26.id = T24.countryRegionId','PRM_DISCIPLINARY_ACTION_DETAIL_SU_ID', 
    'MISCONDUCT_DETAIL,DATE_OF_MISCONDUCT,TYPE_OF_MISCONDUCT,STUDENT_ID,MOBILE_NO,EMAIL_ID,SECONDARY_EMAIL_ID,STUDENT_NAME,FIRST_NAME,MIDDLE_NAME,LAST_NAME,BRAND_CAMPUS_NAME,BRAND_NAME,CAMPUS_NAME,CAMPUS_EMAIL_ID,BRAND_CAMPUS_WEBSITE,
     CAMPUS_ADDRESS,CAMPUS_CITY,CAMPUS_COUNTRY,CAMPUS_COUNTRY_REGION,CAMPUS_POSTAL_CODE,CAMPUS_PHONE_NUMBER,CAMPUS_MOBILE_NUMBER,CAMPUS_PRIMARY_EMAIL_ID,CAMPUS_ALTERNATE_EMAIL_ID,
     LOGO_URL,HEADER_URL,FOOTER_URL,MOBILE_COUNTRY_CODE', 
'WHERE daa.id =PRM_DISCIPLINARY_ACTION_DETAIL_SU_ID', '0');

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('TYPE_OF_MISCONDUCT', 'Type of Misconduct',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('DATE_OF_MISCONDUCT', 'Date of Misconduct',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('MISCONDUCT_DETAIL', 'Misconduct Details',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('STUDENT_ID', 'Student ID',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('MOBILE_NO', 'Mobile No',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('EMAIL_ID', 'Email Id',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('SECONDARY_EMAIL_ID', 'Alternate Email Id',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('STUDENT_NAME', 'Student Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('FIRST_NAME', 'First Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('MIDDLE_NAME', 'Middle Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('LAST_NAME', 'Last Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('BRAND_CAMPUS_NAME', 'Brand Campus Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('BRAND_NAME', 'Brand Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('CAMPUS_NAME', 'Campus Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('CAMPUS_EMAIL_ID', 'Campus Email Id',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('BRAND_CAMPUS_WEBSITE', 'Website',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('CAMPUS_ADDRESS', 'Campus Address',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('CAMPUS_CITY', 'Campus City',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('CAMPUS_COUNTRY', 'Campus Country',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('CAMPUS_COUNTRY_REGION', 'Campus Region',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('CAMPUS_POSTAL_CODE', 'Campus Postal Code',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('CAMPUS_PHONE_NUMBER', 'Campus Phone Number with Code',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('CAMPUS_MOBILE_NUMBER', 'Campus Mobile Number with Code',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('CAMPUS_PRIMARY_EMAIL_ID', 'Campus Primary Email Address',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('CAMPUS_ALTERNATE_EMAIL_ID', 'Campus Secondary Email Address',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('LOGO_URL', 'Logo URL',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('HEADER_URL', 'Header URL',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('FOOTER_URL', 'Footer URL',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('MOBILE_COUNTRY_CODE', 'Mobile Country Code',@dydtdatalinitemId+1);

SET @dydtTemplateconfId=(SELECT MAX(id) FROM `dydt_template_conf`);

INSERT INTO `dydt_template_conf` (`id`, `documentTypeId`, `templateName`, `templateType`, `whetherDefault`,`templateContent`)
VALUES (@dydtTemplateconfId+1, @dydtdocumenttypeId+1, 'Disciplinary Action Template', 'HTMLTEMPLATE', '0','');

END IF; 


END $$
CALL V20250526110320__Insert_DisciplinaryActionEvent() $$
DROP PROCEDURE IF EXISTS V20250526110320__Insert_DisciplinaryActionEvent $$
DELIMITER ;